/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.example.random;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.dispatcher.DefaultDispatcher;
import com.flipkart.hydra.dispatcher.exception.DispatchFailedException;
import com.flipkart.hydra.example.random.callables.EchoValueCallable;
import com.flipkart.hydra.example.random.callables.NullValueCallable;
import com.flipkart.hydra.task.DefaultTask;
import com.flipkart.hydra.task.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Example {
    public static void main(String[] args) throws ComposerInstantiationException, DispatchFailedException, ComposerEvaluationException {
        HashMap<String, Object> initialParams = Example.getInitialParams();
        Map<String, Task> tasks = Example.getTasks();
        HashMap<String, Object> responseContext = new HashMap<String, Object>(){
            {
                this.put("v1", "{{$taskParam1}}");
                this.put("v2", "{{$taskParam5}}");
                this.put("v3", "{{$taskParam4}}");
                this.put("v4", "{{$(keys, $taskParam2)}}");
            }
        };
        ExecutorService executor = Executors.newCachedThreadPool();
        DefaultDispatcher defaultDispatcher = new DefaultDispatcher(executor);
        Object response = defaultDispatcher.execute(initialParams, tasks, (Object)responseContext);
        System.out.println(response);
        executor.shutdown();
    }

    private static HashMap<String, Object> getInitialParams() {
        return new HashMap<String, Object>(){
            {
                this.put("initialParam1", "initialParamValue1");
                this.put("initialParam2", "initialParamValue2");
            }
        };
    }

    private static Map<String, Task> getTasks() throws ComposerInstantiationException {
        return new HashMap<String, Task>(){
            {
                this.put("taskParam1", Example.getFirstTask());
                this.put("taskParam2", Example.getSecondTask());
                this.put("taskParam3", Example.getThirdTask());
                this.put("taskParam4", Example.getFourthTask());
                this.put("taskParam5", Example.getFifthTask());
            }
        };
    }

    private static Task getFirstTask() throws ComposerInstantiationException {
        HashMap<String, Object> context = new HashMap<String, Object>(){
            {
                this.put("value", "{{$initialParam1}}");
            }
        };
        return new DefaultTask(EchoValueCallable.class, (Object)context);
    }

    private static Task getSecondTask() throws ComposerInstantiationException {
        HashMap<String, Object> context = new HashMap<String, Object>(){
            {
                this.put("value", new HashMap<String, Object>(){
                    {
                        this.put("value1", "{{$taskParam1}}");
                        this.put("value2", "{{$initialParam2}}");
                        this.put("value3", new HashMap<String, Object>(){
                            {
                                this.put("subValue1", "fixedValue");
                            }
                        });
                    }
                });
            }
        };
        return new DefaultTask(EchoValueCallable.class, (Object)context);
    }

    private static Task getThirdTask() throws ComposerInstantiationException {
        return new DefaultTask(NullValueCallable.class, new HashMap());
    }

    private static Task getFourthTask() throws ComposerInstantiationException {
        HashMap<String, Object> context = new HashMap<String, Object>(){
            {
                this.put("value", new HashMap<String, Object>(){
                    {
                        this.put("value1", "{{$taskParam1}}");
                        this.put("value2", new HashMap<String, Object>(){
                            {
                                this.put("subValue1", "{{#$taskParam3.value1}}");
                                this.put("subValue2", "{{$taskParam2.value3.subValue1}}");
                            }
                        });
                    }
                });
            }
        };
        return new DefaultTask(EchoValueCallable.class, (Object)context);
    }

    private static Task getFifthTask() throws ComposerInstantiationException {
        Composer composer = new Composer(){

            public Object compose(Map<String, Object> values) throws ComposerEvaluationException {
                return new HashMap<String, Object>(){
                    {
                        this.put("value", "hardcodedValue");
                    }
                };
            }

            public List<String> getDependencies() {
                return new ArrayList<String>();
            }
        };
        return new DefaultTask(EchoValueCallable.class, composer);
    }
}

