/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.example.employee;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.DefaultComposer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.dispatcher.DefaultDispatcher;
import com.flipkart.hydra.dispatcher.exception.DispatchFailedException;
import com.flipkart.hydra.example.employee.callables.EmployeeDepartmentService;
import com.flipkart.hydra.example.employee.callables.EmployeeIdentificationService;
import com.flipkart.hydra.example.employee.callables.EmployeeInfoService;
import com.flipkart.hydra.example.employee.callables.EmployeeSalaryService;
import com.flipkart.hydra.expression.DefaultExpression;
import com.flipkart.hydra.expression.exception.ExpressionParseException;
import com.flipkart.hydra.task.DefaultTask;
import com.flipkart.hydra.task.Task;
import java.util.HashMap;
import java.util.Map;

public class EmployeeExample {
    public static void main(String[] args) throws ComposerInstantiationException, ExpressionParseException, DispatchFailedException, ComposerEvaluationException {
        Map<String, Object> initialParams = EmployeeExample.getInitialParams();
        Map<String, Task> tasks = EmployeeExample.getTasks();
        Composer response = EmployeeExample.getResponseComposer();
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        Object output = dispatcher.execute(initialParams, tasks, response);
        System.out.println(output);
    }

    private static Map<String, Object> getInitialParams() {
        HashMap<String, Object> initialParams = new HashMap<String, Object>();
        initialParams.put("employeeName", "John Doe");
        return initialParams;
    }

    private static Map<String, Task> getTasks() throws ComposerInstantiationException, ExpressionParseException {
        HashMap<String, Task> tasks = new HashMap<String, Task>();
        DefaultExpression expression1 = new DefaultExpression("$employeeName");
        DefaultComposer composer1 = new DefaultComposer((Object)expression1, true);
        DefaultTask employeeIDTask = new DefaultTask(EmployeeIdentificationService.class, (Composer)composer1);
        DefaultComposer composer2 = new DefaultComposer((Object)"{{$employeeName}}");
        DefaultTask joiningDateTask = new DefaultTask(EmployeeInfoService.class, (Composer)composer2);
        DefaultTask departmentTask = new DefaultTask(EmployeeDepartmentService.class, (Object)"{{$employeeID}}");
        DefaultTask salaryTask = new DefaultTask(EmployeeSalaryService.class, (Object)"{{$employeeID}}");
        tasks.put("joiningDate", (Task)joiningDateTask);
        tasks.put("salary", (Task)salaryTask);
        tasks.put("department", (Task)departmentTask);
        tasks.put("employeeID", (Task)employeeIDTask);
        return tasks;
    }

    private static Composer getResponseComposer() throws ComposerInstantiationException {
        HashMap<String, String> responseContext = new HashMap<String, String>();
        responseContext.put("employeeName", "{{$employeeName}}");
        responseContext.put("employeeID", "{{$employeeID}}");
        responseContext.put("department", "{{$department}}");
        responseContext.put("salary", "{{#$salary}}");
        return new DefaultComposer(responseContext);
    }
}

