/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.hibernate;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import com.flipkart.gjex.core.Bundle;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.job.ScheduledJob;
import com.flipkart.gjex.core.service.Service;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.setup.Environment;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.flipkart.gjex.db.DatabaseConfiguration;
import com.flipkart.gjex.hibernate.SessionFactoryFactory;
import com.google.common.collect.ImmutableList;
import io.dropwizard.db.PooledDataSourceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.server.ResourceConfig;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public abstract class HibernateBundle<T extends GJEXConfiguration, U extends Map>
implements Bundle<T, U>,
DatabaseConfiguration {
    public static final String DEFAULT_NAME = "hibernate";
    private final List<Class<?>> entities;
    private final SessionFactoryFactory sessionFactoryFactory;
    private SessionFactory sessionFactory;
    private boolean lazyLoadingEnabled;

    protected HibernateBundle(Class<?> entity, Class<?> ... entities) {
        ArrayList entityClasses = new ArrayList();
        entityClasses.add(entity);
        entityClasses.addAll(Arrays.asList(entities));
        this.entities = Collections.unmodifiableList(entityClasses);
        this.sessionFactoryFactory = new SessionFactoryFactory();
    }

    protected HibernateBundle(ImmutableList<Class<?>> entities, SessionFactoryFactory sessionFactoryFactory) {
        this.lazyLoadingEnabled = true;
        this.entities = entities;
        this.sessionFactoryFactory = sessionFactoryFactory;
    }

    public final void initialize(Bootstrap<?, ?> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)this.createHibernate5Module());
        PooledDataSourceFactory dbConfig = this.getDataSourceFactory(bootstrap.getConfiguration());
        this.sessionFactory = this.sessionFactoryFactory.build(this, bootstrap.getMetricRegistry(), dbConfig, this.entities, this.name());
    }

    protected Hibernate5Module createHibernate5Module() {
        Hibernate5Module module = new Hibernate5Module();
        if (this.lazyLoadingEnabled) {
            module.enable(Hibernate5Module.Feature.FORCE_LAZY_LOADING);
        }
        return module;
    }

    protected String name() {
        return DEFAULT_NAME;
    }

    public void run(T t, U u, Environment environment) {
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected void configure(Configuration configuration) {
    }

    public List<Service> getServices() {
        return Collections.emptyList();
    }

    public List<HealthCheck> getHealthChecks() {
        return Collections.emptyList();
    }

    public List<TracingSampler> getTracingSamplers() {
        return Collections.emptyList();
    }

    public List<ResourceConfig> getResourceConfigs() {
        return Collections.emptyList();
    }

    public List<GrpcFilter> getGrpcFilters() {
        return Collections.emptyList();
    }

    public List<HttpFilter> getHTTPFilters() {
        return Collections.emptyList();
    }

    public List<ScheduledJob> getScheduledJobs() {
        return Collections.emptyList();
    }
}

