/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.task.ConcurrentTask;
import com.flipkart.gjex.core.task.FutureDecorator;
import com.flipkart.gjex.core.task.TaskExecutor;
import com.google.inject.AbstractModule;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.configuration.Configuration;

public class TaskModule<T>
extends AbstractModule
implements Logging {
    protected void configure() {
        TaskMethodInterceptor methodInterceptor = new TaskMethodInterceptor();
        this.requestInjection(methodInterceptor);
        this.bindInterceptor(Matchers.any(), (Matcher)new TaskMethodMatcher(), new MethodInterceptor[]{methodInterceptor});
    }

    class TaskMethodMatcher
    extends AbstractMatcher<Method> {
        TaskMethodMatcher() {
        }

        public boolean matches(Method method) {
            boolean matches = false;
            for (Annotation ann : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = ann.annotationType();
                if (!ConcurrentTask.class.equals(annotationType)) continue;
                matches = true;
                break;
            }
            return matches;
        }
    }

    class TaskMethodInterceptor
    implements MethodInterceptor {
        @Inject
        @Named(value="GlobalFlattenedConfig")
        private Provider<Configuration> globalConfigurationProvider;

        TaskMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            ConcurrentTask task = invocation.getMethod().getAnnotation(ConcurrentTask.class);
            Configuration globalConfig = (Configuration)this.globalConfigurationProvider.get();
            int timeout = 0;
            if (task.timeoutConfig().length() > 0) {
                timeout = globalConfig.getInt(task.timeoutConfig());
            }
            if (task.timeout() > 0) {
                timeout = task.timeout();
            }
            int concurrency = 0;
            if (task.concurrencyConfig().length() > 0) {
                concurrency = globalConfig.getInt(task.concurrencyConfig());
            }
            if (task.concurrency() > 0) {
                concurrency = task.concurrency();
            }
            return new FutureDecorator(new TaskExecutor(invocation, invocation.getMethod().getDeclaringClass().getSimpleName(), invocation.getMethod().getName(), concurrency, timeout, task.withRequestHedging()), task.completion());
        }
    }
}

