/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.tracing.TracingSamplerHolder;
import com.flipkart.gjex.core.web.DashboardHealthCheckResource;
import com.flipkart.gjex.core.web.DashboardResource;
import com.flipkart.gjex.core.web.HealthCheckResource;
import com.flipkart.gjex.core.web.RotationManagementResource;
import com.flipkart.gjex.core.web.TracingResource;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import io.prometheus.metrics.exporter.servlet.javax.PrometheusMetricsServlet;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.servlet.ServletContainer;

public class DashboardModule<T extends GJEXConfiguration, U extends Map>
extends AbstractModule
implements Logging {
    private final Bootstrap<T, U> bootstrap;

    public DashboardModule(Bootstrap<T, U> bootstrap) {
        this.bootstrap = bootstrap;
    }

    protected void configure() {
    }

    @Named(value="DashboardJettyServer")
    @Provides
    @Singleton
    Server getDashboardJettyServer(@Named(value="Dashboard.service.port") int port, @Named(value="DashboardResourceConfig") ResourceConfig resourceConfig, @Named(value="DashboardHealthCheckResourceConfig") ResourceConfig dashboardHealthCheckResourceConfig, @Named(value="Dashboard.service.acceptors") int acceptorThreads, @Named(value="Dashboard.service.selectors") int selectorThreads, @Named(value="Dashboard.service.workers") int maxWorkerThreads, @Named(value="JSONMarshallingProvider") JacksonJaxbJsonProvider provider) {
        resourceConfig.register((Object)provider);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        URL webRootLocation = ((Object)((Object)this)).getClass().getResource("/webroot/pages/dashboard.ftl");
        if (webRootLocation == null) {
            this.warn("Webroot location not found! Unable to find root location for Dashboard.");
        }
        ServletContextHandler context = new ServletContextHandler();
        try {
            URI webRootUri = URI.create(webRootLocation.toURI().toASCIIString().replaceFirst("/pages/dashboard.ftl$", "/"));
            context.setContextPath("/");
            context.setBaseResource(Resource.newResource((URI)webRootUri));
            context.addServlet(DefaultServlet.class, "/");
        }
        catch (Exception e) {
            this.error("Unable to set resource base for Dashboard.", e);
        }
        context.getMimeTypes().addMimeMapping("txt", "text/plain;charset=utf-8");
        server.setHandler((Handler)context);
        context.setAttribute("GJEX_HealthCheckRegistry", (Object)this.bootstrap.getHealthCheckRegistry());
        context.addServlet(new ServletHolder((Servlet)new ServletContainer(dashboardHealthCheckResourceConfig)), this.bootstrap.getConfiguration().getDashboardService().getHealthCheckPath());
        context.addServlet(new ServletHolder((Servlet)new ServletContainer(resourceConfig)), "/admin/*");
        context.addServlet(HystrixMetricsStreamServlet.class, "/stream/hystrix.stream.command.local");
        context.addServlet(HystrixMetricsStreamServlet.class, "/stream/hystrix.stream.global");
        context.addServlet(HystrixMetricsStreamServlet.class, "/stream/hystrix.stream.tp.local");
        context.addServlet(PrometheusMetricsServlet.class, "/metrics");
        InstrumentedHandler handler = new InstrumentedHandler(this.bootstrap.getMetricRegistry());
        handler.setName("gjex-dashboard");
        handler.setHandler((Handler)context);
        server.setHandler((Handler)handler);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="APIJettyServer")
    @Provides
    @Singleton
    Server getAPIJettyServer(@Named(value="APIVanillaJettyServer") Server server, @Named(value="ApiServletContext") ServletContextHandler context, @Named(value="HealthCheckResourceConfig") ResourceConfig healthCheckResourceConfig, @Named(value="RotationManagementResourceConfig") ResourceConfig rotationManagementResourceConfig, @Named(value="TracingResourceConfig") ResourceConfig tracingResourceConfig, @Named(value="TracingSamplerHolder") TracingSamplerHolder tracingSamplerHolder, @Named(value="JSONMarshallingProvider") JacksonJaxbJsonProvider provider) throws URISyntaxException, UnknownHostException {
        healthCheckResourceConfig.register((Object)provider);
        String healthCheckPath = this.bootstrap.getConfiguration().getApiService().getHealthCheckPath();
        ServletHolder healthCheckServlet = new ServletHolder((Servlet)new ServletContainer(healthCheckResourceConfig));
        context.addServlet(healthCheckServlet, healthCheckPath);
        rotationManagementResourceConfig.register((Object)provider);
        ServletHolder rotationManagementServlet = new ServletHolder((Servlet)new ServletContainer(rotationManagementResourceConfig));
        context.addServlet(rotationManagementServlet, "/rotation/*");
        tracingResourceConfig.register((Object)provider);
        ServletHolder tracingServlet = new ServletHolder((Servlet)new ServletContainer(tracingResourceConfig));
        context.addServlet(tracingServlet, "/tracingconfig");
        context.setAttribute("GJEX_HealthCheckRegistry", (Object)this.bootstrap.getHealthCheckRegistry());
        context.setAttribute("GJEX_TracingSamplerHolder", (Object)tracingSamplerHolder);
        InstrumentedHandler handler = new InstrumentedHandler(this.bootstrap.getMetricRegistry());
        handler.setName("gjex-api");
        handler.setHandler((Handler)context);
        server.setHandler((Handler)handler);
        return server;
    }

    @Named(value="APIVanillaJettyServer")
    @Provides
    @Singleton
    Server getAPIVanillaJettyServer(@Named(value="Api.service.port") int port, @Named(value="Api.service.acceptors") int acceptorThreads, @Named(value="Api.service.selectors") int selectorThreads, @Named(value="Api.service.workers") int maxWorkerThreads) throws URISyntaxException, UnknownHostException {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="JSONMarshallingProvider")
    @Singleton
    @Provides
    JacksonJaxbJsonProvider getJSONMarshallingProvider(ObjectMapper objectMapper) {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(objectMapper);
        return provider;
    }

    @Named(value="ApiServletContext")
    @Singleton
    @Provides
    public ServletContextHandler getApiServletContext(@Named(value="APIVanillaJettyServer") Server server) {
        return new ServletContextHandler((HandlerContainer)server, "/");
    }

    @Named(value="HealthCheckResourceConfig")
    @Singleton
    @Provides
    ResourceConfig getAPIResourceConfig(HealthCheckResource healthCheckResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)healthCheckResource);
        resourceConfig.setApplicationName("@@GJEXCoreApplication@@");
        return resourceConfig;
    }

    @Named(value="DashboardHealthCheckResourceConfig")
    @Singleton
    @Provides
    ResourceConfig getAPIResourceConfig(DashboardHealthCheckResource dashboardHealthCheckResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)dashboardHealthCheckResource);
        resourceConfig.setApplicationName("@@GJEXCoreApplication@@");
        return resourceConfig;
    }

    @Named(value="RotationManagementResourceConfig")
    @Singleton
    @Provides
    ResourceConfig getRotationManagementResourceConfig(RotationManagementResource rotationManagementResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)rotationManagementResource);
        resourceConfig.setApplicationName("@@GJEXCoreApplication@@");
        return resourceConfig;
    }

    @Named(value="TracingResourceConfig")
    @Singleton
    @Provides
    ResourceConfig getTracingResourceConfig(TracingResource tracingResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)tracingResource);
        resourceConfig.setApplicationName("@@GJEXCoreApplication@@");
        return resourceConfig;
    }

    @Named(value="DashboardResourceConfig")
    @Singleton
    @Provides
    ResourceConfig getDashboardResourceConfig(DashboardResource dashboardResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)dashboardResource);
        resourceConfig.setApplicationName("@@GJEXCoreApplication@@");
        resourceConfig.property("jersey.config.server.mvc.templateBasePath.freemarker", (Object)"webroot/pages");
        resourceConfig.register(FreemarkerMvcFeature.class);
        return resourceConfig;
    }
}

