/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.service;

import com.flipkart.gjex.core.filter.http.AccessLogHttpFilter;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.filter.http.HttpFilterConfig;
import com.flipkart.gjex.core.filter.http.HttpFilterParams;
import com.flipkart.gjex.core.filter.http.JavaxFilterParams;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.AbstractService;
import com.flipkart.gjex.http.interceptor.HttpFilterInterceptor;
import com.flipkart.gjex.web.ResourceRegistrar;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.glassfish.jersey.server.ResourceConfig;

@Singleton
@Named(value="APIServer")
public class ApiServer
extends AbstractService
implements Logging {
    private final Server apiServer;
    private final ResourceRegistrar resourceRegistrar;
    private final ServletContextHandler context;
    private HttpFilterInterceptor httpFilterInterceptor;
    private List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();

    @Inject
    public ApiServer(@Named(value="APIJettyServer") Server apiServer, @Named(value="ApiServletContext") ServletContextHandler context, @Named(value="HttpFilterInterceptor") HttpFilterInterceptor httpFilterInterceptor, ResourceRegistrar resourceRegistrar) {
        this.apiServer = apiServer;
        this.context = context;
        this.httpFilterInterceptor = httpFilterInterceptor;
        this.resourceRegistrar = resourceRegistrar;
    }

    public void registerResources(List<ResourceConfig> resourceConfigs) {
        this.resourceConfigs.addAll(resourceConfigs);
    }

    public void registerFilters(List<HttpFilterParams> httpFilterParamsList, List<JavaxFilterParams> javaxFilterParamsList, HttpFilterConfig httpFilterConfig) {
        this.configureAccessLog(httpFilterParamsList, httpFilterConfig);
        this.httpFilterInterceptor.registerFilters(httpFilterParamsList);
        this.context.addFilter(new FilterHolder((Filter)this.httpFilterInterceptor), "/*", EnumSet.of(DispatcherType.REQUEST));
        for (JavaxFilterParams javaxFilterParams : javaxFilterParamsList) {
            this.context.addFilter(new FilterHolder(javaxFilterParams.getFilter()), javaxFilterParams.getPathSpec(), EnumSet.of(DispatcherType.REQUEST));
        }
    }

    private void configureAccessLog(List<HttpFilterParams> httpFilterParamsList, HttpFilterConfig httpFilterConfig) {
        if (httpFilterConfig.isEnableAccessLogs()) {
            AccessLogHttpFilter accessLogHttpFilter = new AccessLogHttpFilter();
            if (StringUtils.isNotEmpty((String)httpFilterConfig.getAccessLogFormat())) {
                AccessLogHttpFilter.setFormat((String)httpFilterConfig.getAccessLogFormat());
            }
            httpFilterParamsList.add(0, HttpFilterParams.builder().filter((HttpFilter)accessLogHttpFilter).pathSpec("/*").build());
        }
    }

    public void doStart() throws Exception {
        this.resourceRegistrar.registerResources(this.resourceConfigs);
        this.apiServer.start();
        this.info("API Server started and listening on port : " + this.apiServer.getURI().getPort());
    }

    public void doStop() {
        try {
            this.apiServer.stop();
        }
        catch (Exception e) {
            this.error("Error stopping API server : " + e.getMessage(), e);
        }
    }
}

