/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.channel;

import com.flipkart.gjex.grpc.channel.ChannelConfig;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import javax.inject.Inject;

public class InstrumentedChannel
extends Channel {
    @Inject
    private MetricRegistry metricRegistry;
    private final ManagedChannel _delegate;

    @Inject
    public InstrumentedChannel(ChannelConfig channelConfig) {
        this._delegate = ManagedChannelBuilder.forAddress((String)channelConfig.getHostname(), (int)channelConfig.getPort()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        ClientCall response;
        Timer.Context clientTimer = this.metricRegistry.timer(this.getMetricName(methodDescriptor.getFullMethodName())).time();
        try {
            response = this._delegate.newCall(methodDescriptor, callOptions);
        }
        finally {
            clientTimer.stop();
        }
        return response;
    }

    public String authority() {
        return this._delegate.authority();
    }

    private String getMetricName(String fullMethodName) {
        return fullMethodName.replace("/", ".");
    }
}

