/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.healthcheck.RotationManagementBasedHealthCheck;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.Api;
import com.flipkart.gjex.core.web.filter.HttpAccessLogFilter;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import io.dropwizard.metrics5.health.HealthCheck;
import io.grpc.BindableService;
import io.grpc.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.Filter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.configuration.Configuration;

public class ApiModule<T>
extends AbstractModule
implements Logging {
    protected void configure() {
        ApiMethodInterceptor methodInterceptor = new ApiMethodInterceptor();
        this.requestInjection(methodInterceptor);
        this.bindInterceptor(Matchers.any(), (Matcher)new ApiMethodMatcher(), new MethodInterceptor[]{methodInterceptor});
        this.bind(HealthCheck.class).to(RotationManagementBasedHealthCheck.class);
        this.bind(Filter.class).annotatedWith((Annotation)Names.named((String)"HttpAccessLogFilter")).to(HttpAccessLogFilter.class);
    }

    @Named(value="ApiScheduledExecutor")
    @Provides
    @Singleton
    ScheduledExecutorService getScheduledExecutorService(GJEXConfiguration configuration) {
        return Executors.newScheduledThreadPool(configuration.getApiService().getScheduledExecutorThreadPoolSize());
    }

    class ApiMethodMatcher
    extends AbstractMatcher<Method> {
        ApiMethodMatcher() {
        }

        public boolean matches(Method method) {
            boolean matches = false;
            for (Annotation ann : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = ann.annotationType();
                if (!Api.class.equals(annotationType)) continue;
                matches = true;
                break;
            }
            return matches;
        }
    }

    class ApiMethodInterceptor
    implements MethodInterceptor {
        @Inject
        @Named(value="GlobalFlattenedConfig")
        private Provider<Configuration> globalConfigurationProvider;
        @Inject
        @Named(value="ApiScheduledExecutor")
        private Provider<ScheduledExecutorService> scheduledExecutorServiceProvider;

        ApiMethodInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Context.CancellableContext cancellableContext = null;
            Context previous = null;
            Api api = invocation.getMethod().getAnnotation(Api.class);
            if (api != null) {
                String methodInvoked = (invocation.getMethod().getDeclaringClass().getSimpleName() + "." + invocation.getMethod().getName()).toLowerCase();
                if (!BindableService.class.isAssignableFrom(invocation.getMethod().getDeclaringClass())) {
                    ApiModule.this.warn("Api declarations are interpreted only for sub-types of gRPC BindableService. Api declared for : " + methodInvoked + " will not be interpreted/honored");
                }
                int deadline = 0;
                if (api.deadlineConfig().length() > 0) {
                    deadline = ((Configuration)this.globalConfigurationProvider.get()).getInt(api.deadlineConfig());
                }
                if (Context.current().getDeadline() == null) {
                    cancellableContext = Context.current().withDeadlineAfter((long)deadline, TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.scheduledExecutorServiceProvider.get());
                    previous = cancellableContext.attach();
                } else {
                    ApiModule.this.info("Not setting API deadline as client has already specified a deadline");
                }
            }
            Object result = null;
            try {
                result = invocation.proceed();
            }
            finally {
                if (cancellableContext != null) {
                    cancellableContext.detach(previous);
                    ApiModule.this.debug("Cancelled a cancellable context");
                    cancellableContext.cancel(null);
                }
            }
            return result;
        }
    }
}

