/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.setup.Environment;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import java.util.Map;

public class GJEXEnvironmentModule<T extends GJEXConfiguration, U extends Map>
extends AbstractModule
implements Logging {
    private static final String ILLEGAL_GJEX_MODULE_STATE = "The GJEX environment has not been set yet. This is likely caused by trying to access GJEX environment during the bootstrap phase.";
    private T configuration;
    private Environment environment;
    private Class<? super T> configurationClass;

    public GJEXEnvironmentModule(Class<T> configurationClass) {
        this.configurationClass = configurationClass;
    }

    protected void configure() {
        CustomConfigurationProvider provider = new CustomConfigurationProvider();
        this.bind(this.configurationClass).toProvider((Provider)provider);
        if (this.configurationClass != GJEXConfiguration.class) {
            this.bind(GJEXConfiguration.class).toProvider((Provider)provider);
        }
    }

    public void setEnvironmentData(T configuration, Environment environment) {
        this.configuration = configuration;
        this.environment = environment;
    }

    @Provides
    public Environment providesEnvironment() {
        if (this.environment == null) {
            throw new ProvisionException(ILLEGAL_GJEX_MODULE_STATE);
        }
        return this.environment;
    }

    private class CustomConfigurationProvider
    implements Provider<T> {
        private CustomConfigurationProvider() {
        }

        public T get() {
            if (GJEXEnvironmentModule.this.configuration == null) {
                throw new ProvisionException(GJEXEnvironmentModule.ILLEGAL_GJEX_MODULE_STATE);
            }
            return GJEXEnvironmentModule.this.configuration;
        }
    }
}

