/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice;

import com.flipkart.gjex.core.Bundle;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.job.ScheduledJob;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.Service;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.setup.Environment;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.flipkart.gjex.grpc.service.ApiServer;
import com.flipkart.gjex.grpc.service.GrpcServer;
import com.flipkart.gjex.grpc.service.ScheduledJobManager;
import com.flipkart.gjex.guice.module.ApiModule;
import com.flipkart.gjex.guice.module.ConfigModule;
import com.flipkart.gjex.guice.module.DashboardModule;
import com.flipkart.gjex.guice.module.GJEXEnvironmentModule;
import com.flipkart.gjex.guice.module.ServerModule;
import com.flipkart.gjex.guice.module.TaskModule;
import com.flipkart.gjex.guice.module.TracingModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.palominolabs.metrics.guice.MetricsInstrumentationModule;
import io.dropwizard.metrics5.health.HealthCheck;
import io.grpc.BindableService;
import io.grpc.health.v1.HealthGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.glassfish.jersey.server.ResourceConfig;
import ru.vyarus.guice.validator.ImplicitValidationModule;

public class GuiceBundle<T extends GJEXConfiguration, U extends Map>
implements Bundle<T, U>,
Logging {
    private List<Module> modules;
    private Injector baseInjector;
    private List<Service> services;
    private List<Filter> filters;
    private List<HealthCheck> healthchecks;
    private List<TracingSampler> tracingSamplers;
    private List<ScheduledJob> scheduledJobs;
    private List<ResourceConfig> resourceConfigs;
    private Optional<Class<T>> configurationClass;
    private GJEXEnvironmentModule gjexEnvironmentModule;

    private GuiceBundle(List<Module> modules, Optional<Class<T>> configurationClass) {
        Preconditions.checkNotNull(modules);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
        this.modules = modules;
        this.configurationClass = configurationClass;
    }

    public void initialize(Bootstrap<?, ?> bootstrap) {
        this.modules.add((Module)new ConfigModule(bootstrap));
        this.gjexEnvironmentModule = this.configurationClass.isPresent() ? new GJEXEnvironmentModule(this.configurationClass.get()) : new GJEXEnvironmentModule(GJEXConfiguration.class);
        this.modules.add((Module)this.gjexEnvironmentModule);
        this.modules.add((Module)MetricsInstrumentationModule.builder().withMetricRegistry(bootstrap.getMetricRegistry()).build());
        this.modules.add((Module)new ImplicitValidationModule());
        this.modules.add((Module)new ApiModule());
        this.modules.add((Module)new TracingModule());
        this.modules.add((Module)new TaskModule());
        this.modules.add((Module)new DashboardModule(bootstrap));
        this.modules.add((Module)new ServerModule());
        this.baseInjector = Guice.createInjector(this.modules);
    }

    public void run(T configuration, U configMap, Environment environment) {
        this.setEnvironment(configuration, environment);
        GrpcServer grpcServer = (GrpcServer)((Object)this.baseInjector.getInstance(GrpcServer.class));
        ArrayList<BindableService> bindableServices = new ArrayList<BindableService>();
        bindableServices.addAll(this.getInstances(this.baseInjector, BindableService.class));
        bindableServices.addAll(this.getInstances(this.baseInjector, HealthGrpc.HealthImplBase.class));
        grpcServer.registerServices(bindableServices);
        this.filters = this.getInstances(this.baseInjector, Filter.class);
        grpcServer.registerFilters(this.filters, bindableServices);
        this.tracingSamplers = this.getInstances(this.baseInjector, TracingSampler.class);
        grpcServer.registerTracingSamplers(this.tracingSamplers, bindableServices);
        grpcServer.registerResponseMeteredMethods(bindableServices);
        ScheduledJobManager scheduledJobManager = (ScheduledJobManager)((Object)this.baseInjector.getInstance(ScheduledJobManager.class));
        this.scheduledJobs = this.getInstances(this.baseInjector, ScheduledJob.class);
        scheduledJobManager.registerScheduledJobs(this.scheduledJobs);
        this.services = this.getInstances(this.baseInjector, Service.class);
        this.healthchecks = this.getInstances(this.baseInjector, HealthCheck.class);
        ApiServer apiServer = (ApiServer)((Object)this.baseInjector.getInstance(ApiServer.class));
        this.resourceConfigs = this.getInstances(this.baseInjector, ResourceConfig.class);
        apiServer.registerResources(this.resourceConfigs);
    }

    private void setEnvironment(T configuration, Environment environment) {
        this.gjexEnvironmentModule.setEnvironmentData(configuration, environment);
    }

    public List<Service> getServices() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"Service(s) are only available after GuiceBundle.run() is called");
        return this.services;
    }

    public List<Filter> getFilters() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"Filter(s) are only available after GuiceBundle.run() is called");
        return this.filters;
    }

    public List<HealthCheck> getHealthChecks() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"HealthCheck(s) are only available after GuiceBundle.run() is called");
        return this.healthchecks;
    }

    public List<TracingSampler> getTracingSamplers() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"TracingSampler(s) is only available after GuiceBundle.run() is called");
        return this.tracingSamplers;
    }

    public List<ScheduledJob> getScheduledJobs() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"ScheduledJob(s) are only available after GuiceBundle.run() is called");
        return this.scheduledJobs;
    }

    public List<ResourceConfig> getResourceConfigs() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"ResourceConfig(s) is only available after GuiceBundle.run() is called");
        return this.resourceConfigs;
    }

    public Injector getInjector() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"Injector is only available after GuiceBundle.initialize() is called");
        return this.baseInjector;
    }

    private <S> List<S> getInstances(Injector injector, Class<S> type) {
        ArrayList<Object> instances = new ArrayList<Object>();
        List bindings = injector.findBindingsByType(TypeLiteral.get(type));
        for (Binding binding : bindings) {
            Key key = binding.getKey();
            instances.add(injector.getInstance(key));
        }
        return instances;
    }

    public static class Builder<T extends GJEXConfiguration, U extends Map> {
        private List<Module> modules = Lists.newArrayList();
        private Optional<Class<T>> configurationClass = Optional.empty();

        public Builder<T, U> addModules(Module ... moreModules) {
            for (Module module : moreModules) {
                Preconditions.checkNotNull((Object)module);
                this.modules.add(module);
            }
            return this;
        }

        public Builder<T, U> setConfigClass(Class<T> clazz) {
            this.configurationClass = Optional.ofNullable(clazz);
            return this;
        }

        public GuiceBundle<T, U> build() {
            return new GuiceBundle(this.modules, this.configurationClass);
        }
    }
}

