/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.flipkart.gjex.grpc.channel.ChannelConfig;
import com.flipkart.gjex.grpc.channel.InstrumentedChannel;
import com.flipkart.gjex.grpc.interceptor.ClientTracingInterceptor;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.stub.AbstractStub;
import io.opentracing.Tracer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;

public class ClientModule<T extends AbstractStub<T>>
extends AbstractModule {
    private final Class<T> clazz;
    private final ChannelConfig channelConfig;
    @Inject
    @Named(value="Tracer")
    Tracer tracer;

    public ClientModule(Class<T> clazz, ChannelConfig channelConfig) {
        this.clazz = clazz;
        this.channelConfig = channelConfig;
    }

    protected void configure() {
        this.bind(this.clazz).toProvider((Provider)new StubProvider());
    }

    private class StubProvider
    implements Provider<T> {
        private Channel channel;

        public StubProvider() {
            this.channel = new InstrumentedChannel(ClientModule.this.channelConfig);
            ClientModule.this.binder().requestInjection((Object)this.channel);
        }

        public T get() {
            try {
                Constructor constructor = ClientModule.this.clazz.getDeclaredConstructor(Channel.class);
                constructor.setAccessible(true);
                return ((AbstractStub)constructor.newInstance(this.channel)).withDeadlineAfter(ClientModule.this.channelConfig.getDeadlineInMs(), TimeUnit.MILLISECONDS).withInterceptors(new ClientInterceptor[]{new ClientTracingInterceptor(ClientModule.this.tracer)});
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Grpc stub class doesn't have a constructor which only takes  'Channel' as parameter", e);
            }
        }
    }
}

