/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.grpc.service;

import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.AbstractService;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.flipkart.gjex.grpc.interceptor.FilterInterceptor;
import com.flipkart.gjex.grpc.interceptor.TracingInterceptor;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named(value="GrpcServer")
public class GrpcServer
extends AbstractService
implements Logging {
    private int port = 50051;
    private int maxMessageSize = 0x400000;
    private ServerBuilder<?> grpcServerBuilder;
    private Server grpcServer;
    private FilterInterceptor filterInterceptor;
    private TracingInterceptor tracingInterceptor;

    @Inject
    public GrpcServer(GJEXConfiguration configuration, @Named(value="FilterInterceptor") FilterInterceptor filterInterceptor, @Named(value="TracingInterceptor") TracingInterceptor tracingInterceptor) {
        if (configuration.getGrpc().getPort() > 0) {
            this.port = configuration.getGrpc().getPort();
            this.info("Creating GrpcServer listening on port : " + this.port);
        }
        if (configuration.getGrpc().getMaxMessageSize() > 0) {
            this.maxMessageSize = configuration.getGrpc().getMaxMessageSize();
            this.info("Creating GrpcServer with maximum message size allowed : " + this.maxMessageSize);
        }
        this.grpcServerBuilder = ServerBuilder.forPort((int)this.port).maxInboundMessageSize(this.maxMessageSize);
        this.filterInterceptor = filterInterceptor;
        this.tracingInterceptor = tracingInterceptor;
    }

    public void doStart() throws Exception {
        this.grpcServer = this.grpcServerBuilder.build().start();
        this.info("GJEX GrpcServer started.Hosting these services : ****** Start *****");
        this.grpcServer.getServices().forEach(serviceDefinition -> this.info(serviceDefinition.getServiceDescriptor().getName()));
        this.info("GJEX GrpcServer started.Hosting these services : ****** End *****");
    }

    public void doStop() {
        if (this.grpcServer != null) {
            this.grpcServer.shutdown();
        }
        this.info("GJEX GrpcServer stopped.");
    }

    public void registerFilters(List<Filter> filters, List<BindableService> services) {
        this.filterInterceptor.registerFilters(filters, services);
    }

    public void registerTracingSamplers(List<TracingSampler> samplers, List<BindableService> services) {
        this.tracingInterceptor.registerTracingSamplers(samplers, services);
    }

    public void registerServices(List<BindableService> services) {
        services.forEach(service -> this.grpcServerBuilder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{this.tracingInterceptor, this.filterInterceptor})));
    }
}

