/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.web.DashboardResource;
import com.flipkart.gjex.core.web.HealthCheckResource;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.servlet.ServletContainer;

public class DashboardModule<T extends GJEXConfiguration, U extends Map>
extends AbstractModule
implements Logging {
    private final Bootstrap<T, U> bootstrap;

    public DashboardModule(Bootstrap<T, U> bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Named(value="DashboardJettyServer")
    @Provides
    @Singleton
    Server getDashboardJettyServer(@Named(value="Dashboard.service.port") int port, @Named(value="DashboardResourceConfig") ResourceConfig resourceConfig, @Named(value="Dashboard.service.acceptors") int acceptorThreads, @Named(value="Dashboard.service.selectors") int selectorThreads, @Named(value="Dashboard.service.workers") int maxWorkerThreads, ObjectMapper objectMapper) {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(objectMapper);
        resourceConfig.register((Object)provider);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        URL webRootLocation = ((Object)((Object)this)).getClass().getResource("/webroot/pages/dashboard.ftl");
        if (webRootLocation == null) {
            this.warn("Webroot location not found! Unable to find root location for Dashboard.");
        }
        ServletContextHandler context = new ServletContextHandler();
        try {
            URI webRootUri = URI.create(webRootLocation.toURI().toASCIIString().replaceFirst("/pages/dashboard.ftl$", "/"));
            context.setContextPath("/");
            context.setBaseResource(Resource.newResource((URI)webRootUri));
            context.addServlet(DefaultServlet.class, "/");
        }
        catch (Exception e) {
            this.error("Unable to set resource base for Dashboard.", e);
        }
        context.getMimeTypes().addMimeMapping("txt", "text/plain;charset=utf-8");
        server.setHandler((Handler)context);
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(resourceConfig));
        context.addServlet(servlet, "/admin/*");
        context.addServlet(HystrixMetricsStreamServlet.class, "/stream/hystrix.stream.command.local");
        context.addServlet(HystrixMetricsStreamServlet.class, "/stream/hystrix.stream.global");
        context.addServlet(HystrixMetricsStreamServlet.class, "/stream/hystrix.stream.tp.local");
        InstrumentedHandler handler = new InstrumentedHandler(this.bootstrap.getMetricRegistry());
        handler.setHandler((Handler)context);
        server.setHandler((Handler)handler);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="APIJettyServer")
    @Provides
    @Singleton
    Server getAPIJettyServer(@Named(value="Api.service.port") int port, @Named(value="HealthCheckResourceConfig") ResourceConfig resourceConfig, @Named(value="Api.service.acceptors") int acceptorThreads, @Named(value="Api.service.selectors") int selectorThreads, @Named(value="Api.service.workers") int maxWorkerThreads, ObjectMapper objectMapper) throws URISyntaxException, UnknownHostException {
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(objectMapper);
        resourceConfig.register((Object)provider);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(maxWorkerThreads);
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector http = new ServerConnector(server, acceptorThreads, selectorThreads);
        http.setPort(port);
        server.addConnector((Connector)http);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/*");
        ServletHolder servlet = new ServletHolder((Servlet)new ServletContainer(resourceConfig));
        context.addServlet(servlet, "/*");
        context.setAttribute("GJEX_HealthCheckRegistry", (Object)this.bootstrap.getHealthCheckRegistry());
        InstrumentedHandler handler = new InstrumentedHandler(this.bootstrap.getMetricRegistry());
        handler.setHandler((Handler)context);
        server.setHandler((Handler)handler);
        server.setStopAtShutdown(true);
        return server;
    }

    @Named(value="HealthCheckResourceConfig")
    @Singleton
    @Provides
    public ResourceConfig getAPIResourceConfig(HealthCheckResource healthCheckResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)healthCheckResource);
        return resourceConfig;
    }

    @Named(value="DashboardResourceConfig")
    @Singleton
    @Provides
    public ResourceConfig getDashboardResourceConfig(DashboardResource dashboardResource) {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)dashboardResource);
        resourceConfig.property("jersey.config.server.mvc.templateBasePath.freemarker", (Object)"webroot/pages");
        resourceConfig.register(FreemarkerMvcFeature.class);
        return resourceConfig;
    }
}

