/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.GJEXError;
import com.flipkart.gjex.core.config.ConfigurationException;
import com.flipkart.gjex.core.config.ConfigurationFactory;
import com.flipkart.gjex.core.config.ConfigurationFactoryFactory;
import com.flipkart.gjex.core.config.ConfigurationSourceProvider;
import com.flipkart.gjex.core.config.FlattenedConfiguration;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.util.Pair;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Validator;
import org.apache.commons.configuration.Configuration;

public class ConfigModule<T extends GJEXConfiguration, U extends Map>
extends AbstractModule {
    private final Bootstrap<T, U> bootstrap;
    private final T configuration;
    private final U configMap;

    public ConfigModule(Bootstrap<T, U> _bootstrap) {
        this.bootstrap = _bootstrap;
        try {
            Pair<T, U> pair = this.parseConfiguration(this.bootstrap.getConfigurationFactoryFactory(), this.bootstrap.getConfigurationSourceProvider(), this.bootstrap.getValidatorFactory().getValidator(), this.bootstrap.getConfigPath(), this.bootstrap.getConfigurationClass(), this.bootstrap.getObjectMapper());
            this.configuration = (GJEXConfiguration)pair.getKey();
            this.configMap = (Map)pair.getValue();
            this.bootstrap.setConfiguration(this.configuration);
            this.bootstrap.setConfigMap(this.configMap);
        }
        catch (ConfigurationException | IOException e) {
            throw new GJEXError(GJEXError.ErrorType.runtime, "Error occurred while reading/parsing configuration from source " + this.bootstrap.getConfigPath(), e);
        }
    }

    private Pair<T, U> parseConfiguration(ConfigurationFactoryFactory<T, U> configurationFactoryFactory, ConfigurationSourceProvider provider, Validator validator, String configPath, Class<T> klass, ObjectMapper objectMapper) throws IOException, ConfigurationException {
        ConfigurationFactory configurationFactory = configurationFactoryFactory.create(klass, validator, objectMapper);
        if (configPath != null) {
            return configurationFactory.build(provider, configPath);
        }
        return configurationFactory.build();
    }

    protected void configure() {
        this.bind(Map.class).annotatedWith((Annotation)Names.named((String)"GlobalMapConfig")).toInstance(this.configMap);
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        this.flatten((Map<String, Object>)flattenedMap, null, (Map<?, ?>)this.configMap);
        for (Map.Entry entry : flattenedMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            LinkedBindingBuilder annotatedWith = this.bind(value.getClass()).annotatedWith((Annotation)Names.named((String)key));
            annotatedWith.toInstance(value);
        }
    }

    private void flatten(Map<String, Object> result, String prefix, Map<?, ?> map) {
        Set<?> keys = map.keySet();
        for (Object key : keys) {
            String name = prefix != null ? prefix + "." + key.toString() : key.toString();
            Object value = map.get(key);
            if (value instanceof Map) {
                this.flatten(result, name, (Map)value);
                continue;
            }
            result.put(name, value);
        }
    }

    @Named(value="GlobalFlattenedConfig")
    @Provides
    @Singleton
    public Configuration getGlobalConfiguration(@Named(value="GlobalMapConfig") Map globalMapConfig) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        this.flatten(flattenedMap, null, globalMapConfig);
        FlattenedConfiguration configuration = new FlattenedConfiguration(flattenedMap);
        return configuration;
    }
}

