/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.guice;

import com.codahale.metrics.health.HealthCheck;
import com.flipkart.gjex.core.Bundle;
import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.Service;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.setup.Environment;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.flipkart.gjex.grpc.service.GrpcServer;
import com.flipkart.gjex.guice.module.ApiModule;
import com.flipkart.gjex.guice.module.ConfigModule;
import com.flipkart.gjex.guice.module.DashboardModule;
import com.flipkart.gjex.guice.module.ServerModule;
import com.flipkart.gjex.guice.module.TaskModule;
import com.flipkart.gjex.guice.module.TracingModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.palominolabs.metrics.guice.MetricsInstrumentationModule;
import io.grpc.BindableService;
import java.util.ArrayList;
import java.util.List;
import ru.vyarus.guice.validator.ImplicitValidationModule;

public class GuiceBundle
implements Bundle,
Logging {
    private final List<Module> modules;
    private Injector baseInjector;
    private List<Service> services;
    private List<Filter> filters;
    private List<HealthCheck> healthchecks;
    private List<TracingSampler> tracingSamplers;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GuiceBundle(List<Module> modules) {
        Preconditions.checkNotNull(modules);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0);
        this.modules = modules;
    }

    public void initialize(Bootstrap bootstrap) {
        this.modules.add((Module)new ConfigModule());
        this.modules.add((Module)MetricsInstrumentationModule.builder().withMetricRegistry(bootstrap.getMetricRegistry()).build());
        this.modules.add((Module)new ImplicitValidationModule());
        this.modules.add((Module)new ApiModule());
        this.modules.add((Module)new TracingModule());
        this.modules.add((Module)new TaskModule());
        this.modules.add((Module)new DashboardModule(bootstrap));
        this.modules.add((Module)new ServerModule());
        this.baseInjector = Guice.createInjector(this.modules);
    }

    public void run(Environment environment) {
        GrpcServer grpcServer = (GrpcServer)((Object)this.baseInjector.getInstance(GrpcServer.class));
        List<BindableService> services = this.getInstances(this.baseInjector, BindableService.class);
        grpcServer.registerServices(services);
        this.filters = this.getInstances(this.baseInjector, Filter.class);
        grpcServer.registerFilters(this.filters, services);
        this.tracingSamplers = this.getInstances(this.baseInjector, TracingSampler.class);
        grpcServer.registerTracingSamplers(this.tracingSamplers, services);
        this.services = this.getInstances(this.baseInjector, Service.class);
        this.healthchecks = this.getInstances(this.baseInjector, HealthCheck.class);
    }

    public List<Service> getServices() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"Service(s) are only available after GuiceBundle.run() is called");
        return this.services;
    }

    public List<Filter> getFilters() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"Filter(s) are only available after GuiceBundle.run() is called");
        return this.filters;
    }

    public List<HealthCheck> getHealthChecks() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"HealthCheck(s) are only available after GuiceBundle.run() is called");
        return this.healthchecks;
    }

    public List<TracingSampler> getTracingSamplers() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"TracingSampler(s) is only available after GuiceBundle.run() is called");
        return this.tracingSamplers;
    }

    public Injector getInjector() {
        Preconditions.checkState((this.baseInjector != null ? 1 : 0) != 0, (Object)"Injector is only available after GuiceBundle.initialize() is called");
        return this.baseInjector;
    }

    private <S> List<S> getInstances(Injector injector, Class<S> type) {
        ArrayList<Object> instances = new ArrayList<Object>();
        List bindings = injector.findBindingsByType(TypeLiteral.get(type));
        for (Binding binding : bindings) {
            Key key = binding.getKey();
            instances.add(injector.getInstance(key));
        }
        return instances;
    }

    public static class Builder {
        private List<Module> modules = Lists.newArrayList();

        public Builder addModules(Module ... moreModules) {
            for (Module module : moreModules) {
                Preconditions.checkNotNull((Object)module);
                this.modules.add(module);
            }
            return this;
        }

        public GuiceBundle build() {
            return new GuiceBundle(this.modules);
        }
    }
}

