/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.config;

import com.flipkart.gjex.core.config.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class EnvironmentSubstitutingSourceProvider
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider delegate;
    private final StrSubstitutor substitutor;

    public EnvironmentSubstitutingSourceProvider(ConfigurationSourceProvider delegate) {
        this.delegate = delegate;
        this.substitutor = new StrSubstitutor(System.getenv());
    }

    @Override
    public InputStream open(String path) throws IOException {
        try (InputStream input = this.delegate.open(path);){
            String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            String substituted = this.substitutor.replace(content);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(substituted.getBytes(StandardCharsets.UTF_8));
            return byteArrayInputStream;
        }
    }
}

