/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.healthcheck;

import com.flipkart.gjex.core.logging.Logging;
import io.dropwizard.metrics5.health.HealthCheck;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;

@Singleton
public class RotationManagementBasedHealthCheck
extends HealthCheck
implements Logging {
    private static final String BIR = "bir";
    private static final String OOR = "oor";
    private static final AtomicBoolean rotationStatus = new AtomicBoolean(true);

    protected HealthCheck.Result check() {
        if (RotationManagementBasedHealthCheck.inRotation()) {
            return HealthCheck.Result.healthy((String)("Server is " + RotationManagementBasedHealthCheck.getStatus()));
        }
        return HealthCheck.Result.unhealthy((String)("Server is " + RotationManagementBasedHealthCheck.getStatus()));
    }

    public static String getStatus() {
        return RotationManagementBasedHealthCheck.inRotation() ? BIR : OOR;
    }

    public static String makeOor() {
        rotationStatus.set(false);
        return OOR;
    }

    public static String makeBir() {
        rotationStatus.set(true);
        return BIR;
    }

    public static boolean inRotation() {
        return rotationStatus.get();
    }
}

