/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.context;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.text.StringSubstitutor;

public class AccessLogContext {
    String clientIp;
    String resourcePath;
    Integer contentLength;
    Long responseTime;
    Integer responseStatus;
    String method;
    String protocol;
    Supplier<Map<String, String>> userContext;
    Map<String, String> headers;

    private Map<String, Object> getValueMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            params.put(field.getName(), field.get(this));
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            params.put("headers." + (String)entry.getKey(), entry.getValue());
        }
        params.put("thread", Thread.currentThread().getName());
        if (this.userContext != null) {
            params.putAll(this.userContext.get());
        }
        return params;
    }

    public String format(String templateFormat) {
        return StringSubstitutor.replace((Object)templateFormat, this.getValueMap(), (String)"{", (String)"}");
    }

    private static Map<String, String> $default$headers() {
        return new HashMap<String, String>();
    }

    AccessLogContext(String clientIp, String resourcePath, Integer contentLength, Long responseTime, Integer responseStatus, String method, String protocol, Supplier<Map<String, String>> userContext, Map<String, String> headers) {
        this.clientIp = clientIp;
        this.resourcePath = resourcePath;
        this.contentLength = contentLength;
        this.responseTime = responseTime;
        this.responseStatus = responseStatus;
        this.method = method;
        this.protocol = protocol;
        this.userContext = userContext;
        this.headers = headers;
    }

    public static AccessLogContextBuilder builder() {
        return new AccessLogContextBuilder();
    }

    public static class AccessLogContextBuilder {
        private String clientIp;
        private String resourcePath;
        private Integer contentLength;
        private Long responseTime;
        private Integer responseStatus;
        private String method;
        private String protocol;
        private Supplier<Map<String, String>> userContext;
        private boolean headers$set;
        private Map<String, String> headers$value;

        AccessLogContextBuilder() {
        }

        public AccessLogContextBuilder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public AccessLogContextBuilder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public AccessLogContextBuilder contentLength(Integer contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public AccessLogContextBuilder responseTime(Long responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public AccessLogContextBuilder responseStatus(Integer responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public AccessLogContextBuilder method(String method) {
            this.method = method;
            return this;
        }

        public AccessLogContextBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public AccessLogContextBuilder userContext(Supplier<Map<String, String>> userContext) {
            this.userContext = userContext;
            return this;
        }

        public AccessLogContextBuilder headers(Map<String, String> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        public AccessLogContext build() {
            Map headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = AccessLogContext.$default$headers();
            }
            return new AccessLogContext(this.clientIp, this.resourcePath, this.contentLength, this.responseTime, this.responseStatus, this.method, this.protocol, this.userContext, headers$value);
        }

        public String toString() {
            return "AccessLogContext.AccessLogContextBuilder(clientIp=" + this.clientIp + ", resourcePath=" + this.resourcePath + ", contentLength=" + this.contentLength + ", responseTime=" + this.responseTime + ", responseStatus=" + this.responseStatus + ", method=" + this.method + ", protocol=" + this.protocol + ", userContext=" + this.userContext + ", headers$value=" + this.headers$value + ")";
        }
    }
}

