/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.context.AccessLogContext;
import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.logging.Logging;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public final class AccessLogHttpFilter
extends HttpFilter
implements Logging {
    private long startTime;
    private RequestParams<Set<String>> requestParams;
    private static final Logger logger = Logging.loggerWithName("ACCESS-LOG");
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private String format;

    public AccessLogHttpFilter(String format) {
        this.format = format;
    }

    @Override
    public HttpFilter getInstance() {
        return new AccessLogHttpFilter(this.format);
    }

    @Override
    public void doProcessRequest(ServletRequest req, RequestParams<Set<String>> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
    }

    @Override
    public void doProcessResponse(ServletResponse response) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        AccessLogContext accessLogContext = AccessLogContext.builder().clientIp(this.requestParams.getClientIp()).resourcePath(this.requestParams.getResourcePath()).responseStatus(httpServletResponse.getStatus()).contentLength(Integer.valueOf(httpServletResponse.getHeader(CONTENT_LENGTH_HEADER))).responseTime(System.currentTimeMillis() - this.startTime).build();
        logger.info(accessLogContext.format(this.format));
    }
}

