/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.web;

import com.flipkart.gjex.core.GJEXError;
import com.flipkart.gjex.core.tracing.TracingSamplerHolder;
import com.flipkart.gjex.core.web.ResourceException;
import com.flipkart.gjex.core.web.dto.TracingConfiguration;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Singleton
@Path(value="/")
@Named
public class TracingResource {
    @Context
    private ServletContext servletContext;

    @POST
    @Produces(value={"application/json"})
    public TracingConfiguration updateTracingConfiguration(TracingConfiguration tracingConfig) {
        TracingSamplerHolder tracingSamplerHolder = (TracingSamplerHolder)this.servletContext.getAttribute("GJEX_TracingSamplerHolder");
        try {
            tracingSamplerHolder.updateTracingSampler(tracingConfig.getApiName(), tracingConfig.getComponentName(), tracingConfig.getSamplingRate());
        }
        catch (GJEXError error) {
            throw new ResourceException(error.getMessage());
        }
        return tracingConfig;
    }
}

