/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.grpc;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.flipkart.gjex.core.logging.Logging;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import org.slf4j.Logger;

public class AccessLogGrpcFilter<R extends GeneratedMessageV3, S extends GeneratedMessageV3>
extends GrpcFilter<R, S>
implements Logging {
    protected long startTime;
    protected RequestParams<Metadata> requestParams;
    protected static Logger logger = Logging.loggerWithName("ACCESS-LOG");

    @Override
    public void doProcessRequest(R req, RequestParams<Metadata> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
    }

    @Override
    public void doProcessResponseHeaders(Metadata responseHeaders) {
    }

    @Override
    public void doProcessResponse(S response) {
        String size = null;
        if (response != null) {
            size = String.valueOf(response.getSerializedSize());
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} {} {} {}", new Object[]{this.requestParams.getClientIp(), this.requestParams.getResourcePath(), size, System.currentTimeMillis() - this.startTime});
        }
    }

    @Override
    public GrpcFilter<R, S> getInstance() {
        return new AccessLogGrpcFilter<R, S>();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

