/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.tracing;

import java.util.BitSet;
import java.util.Random;

public class CountingSampler {
    private int i;
    private final BitSet sampleDecisions;

    public CountingSampler(float rate) {
        if (rate < 0.0f || rate > 1.0f) {
            throw new IllegalArgumentException("rate should be between 0.0 and 1: was " + rate);
        }
        if (rate == 0.0f) {
            this.sampleDecisions = new BitSet(100);
        } else {
            int outOf100 = (int)(rate * 100.0f);
            this.sampleDecisions = this.randomBitSet(100, outOf100, new Random());
        }
    }

    public boolean isSampled() {
        boolean result = this.sampleDecisions.get(this.i++);
        if (this.i == 100) {
            this.i = 0;
        }
        return result;
    }

    private BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

