/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.logging;

import com.flipkart.gjex.core.context.GJEXContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface Logging {
    default public String msgWithLogIdent(String msg) {
        String logId = MDC.get((String)"loggingId");
        if (logId == null || logId.isEmpty()) {
            return msg;
        }
        return logId + msg;
    }

    default public Logger loggerWithName(String loggerName) {
        return LoggerFactory.getLogger((String)loggerName);
    }

    default public String getLoggerName() {
        return this.getClass().getCanonicalName();
    }

    default public Logger logger() {
        return LoggerFactory.getLogger((String)this.getLoggerName());
    }

    default public void trace(String msg) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace(this.msgWithLogIdent(msg));
        }
    }

    default public void trace(Throwable e) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace(MDC.get((String)"loggingId"), e);
        }
    }

    default public void trace(String msg, Throwable e) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace(this.msgWithLogIdent(msg), e);
        }
    }

    default public void logTrace(String msg, Throwable e, Object ... args) {
        if (this.logger().isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)this.msgWithLogIdent(msg), (Object[])args);
            this.logger().trace(ft.getMessage(), e);
        }
    }

    default public void traceLog(String msg, Object ... args) {
        this.logger().trace(this.msgWithLogIdent(msg), args);
    }

    default public void debug(String msg) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(this.msgWithLogIdent(msg));
        }
    }

    default public void debug(Throwable e) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(MDC.get((String)"loggingId"), e);
        }
    }

    default public void debug(String msg, Throwable e) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(this.msgWithLogIdent(msg), e);
        }
    }

    default public void logDebug(String msg, Throwable e, Object ... args) {
        if (this.logger().isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)this.msgWithLogIdent(msg), (Object[])args);
            this.logger().debug(ft.getMessage(), e);
        }
    }

    default public void debugLog(String msg, Object ... args) {
        this.logger().debug(this.msgWithLogIdent(msg), args);
    }

    default public void info(String msg) {
        if (this.logger().isInfoEnabled()) {
            this.logger().info(this.msgWithLogIdent(msg));
        }
    }

    default public void info(Throwable e) {
        if (this.logger().isInfoEnabled()) {
            this.logger().info(MDC.get((String)"loggingId"), e);
        }
    }

    default public void info(String msg, Throwable e) {
        if (this.logger().isInfoEnabled()) {
            this.logger().info(this.msgWithLogIdent(msg), e);
        }
    }

    default public void logInfo(String msg, Throwable e, Object ... args) {
        if (this.logger().isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)this.msgWithLogIdent(msg), (Object[])args);
            this.logger().info(ft.getMessage(), e);
        }
    }

    default public void infoLog(String msg, Object ... args) {
        this.logger().info(this.msgWithLogIdent(msg), args);
    }

    default public void warn(String msg) {
        if (this.logger().isWarnEnabled()) {
            this.logger().warn(this.msgWithLogIdent(msg));
        }
    }

    default public void warn(Throwable e) {
        if (this.logger().isWarnEnabled()) {
            this.logger().warn(MDC.get((String)"loggingId"), e);
        }
    }

    default public void warn(String msg, Throwable e) {
        if (this.logger().isWarnEnabled()) {
            this.logger().warn(this.msgWithLogIdent(msg), e);
        }
    }

    default public void logWarn(String msg, Throwable e, Object ... args) {
        if (this.logger().isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)this.msgWithLogIdent(msg), (Object[])args);
            this.logger().warn(ft.getMessage(), e);
        }
    }

    default public void warnLog(String msg, Object ... args) {
        this.logger().warn(this.msgWithLogIdent(msg), args);
    }

    default public void error(String msg) {
        if (this.logger().isErrorEnabled()) {
            this.logger().error(this.msgWithLogIdent(msg));
        }
    }

    default public void error(Throwable e) {
        if (this.logger().isErrorEnabled()) {
            this.logger().error(MDC.get((String)"loggingId"), e);
        }
    }

    default public void error(String msg, Throwable e) {
        if (this.logger().isErrorEnabled()) {
            this.logger().error(this.msgWithLogIdent(msg), e);
        }
    }

    default public void logError(String msg, Throwable e, Object ... args) {
        if (this.logger().isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)this.msgWithLogIdent(msg), (Object[])args);
            this.logger().error(ft.getMessage(), e);
        }
    }

    default public void errorLog(String msg, Object ... args) {
        this.logger().error(this.msgWithLogIdent(msg), args);
    }

    default public void addToTrace(String key, String value) {
        if (GJEXContext.activeSpan() != null) {
            GJEXContext.activeSpan().setTag(key, value);
        }
    }
}

