/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.filter.RequestParams;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpFilter
extends Filter<ServletRequest, ServletResponse, Set<String>>
implements javax.servlet.Filter {
    protected ServletRequest request;
    protected ServletResponse response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest requestInput, ServletResponse responseOutput, FilterChain chain) throws IOException, ServletException {
        try {
            this.request = requestInput;
            this.response = responseOutput;
            RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder();
            if (this.request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)this.request;
                HashSet headersNames = new HashSet(Collections.list(httpServletRequest.getHeaderNames()));
                requestParamsBuilder.metadata(headersNames);
                requestParamsBuilder.clientIp(this.getClientIp(this.request));
                requestParamsBuilder.resourcePath(httpServletRequest.getRequestURI());
            }
            this.doProcessRequest(this.request, requestParamsBuilder.build());
            chain.doFilter(this.request, this.response);
        }
        finally {
            if (this.response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)this.response;
                this.doProcessResponseHeaders(new HashSet(httpServletResponse.getHeaderNames()));
            }
            this.doProcessResponse(this.response);
        }
    }

    private String getClientIp(ServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String xForwardedFor = ((HttpServletRequest)request).getHeader("X-Forwarded-For");
        if (xForwardedFor != null) {
            remoteAddr = xForwardedFor.split(",")[0];
        }
        return remoteAddr;
    }
}

