/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class AccessLogHttpFilter
extends HttpFilter {
    protected long startTime;
    protected RequestParams<Set<String>> requestParams;
    protected Logger logger = this.loggerWithName("ACCESS-LOG");
    protected static final String CONTENT_LENGTH_HEADER = "Content-Length";

    @Override
    public void doProcessRequest(ServletRequest req, RequestParams<Set<String>> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
    }

    @Override
    public void doProcessResponse(ServletResponse response) {
        if (this.logger.isInfoEnabled()) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            this.logger.info("{} {} {} {} {}", new Object[]{this.requestParams.getClientIp(), httpServletRequest.getRequestURI(), httpServletResponse.getStatus(), httpServletResponse.getHeader(CONTENT_LENGTH_HEADER), System.currentTimeMillis() - this.startTime});
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

