/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.grpc;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.ResponseParams;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import org.slf4j.Logger;

public class AccessLogGrpcFilter<R extends GeneratedMessageV3, S extends GeneratedMessageV3>
extends GrpcFilter<R, S> {
    protected long startTime;
    protected RequestParams<R, Metadata> requestParams;
    protected Logger logger = this.getLoggerWithName("ACCESS-LOG");

    @Override
    public void doProcessRequest(RequestParams<R, Metadata> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
    }

    @Override
    public void doProcessResponseHeaders(Metadata responseHeaders) {
    }

    @Override
    public void doProcessResponse(ResponseParams<S> responseParams) {
        String size = null;
        if (responseParams.getResponse() != null) {
            size = String.valueOf(((GeneratedMessageV3)responseParams.getResponse()).getSerializedSize());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} {} {} {}", new Object[]{this.requestParams.getClientIp(), this.requestParams.getResourcePath(), size, System.currentTimeMillis() - this.startTime});
        }
    }

    @Override
    public GrpcFilter<R, S> getInstance() {
        return new AccessLogGrpcFilter<R, S>();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public RequestParams<R, Metadata> getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(RequestParams<R, Metadata> requestParams) {
        this.requestParams = requestParams;
    }
}

