/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.grpc;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.ResponseParams;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;

public class AccessLogGrpcFilter<R extends GeneratedMessageV3, S extends GeneratedMessageV3>
extends GrpcFilter<R, S> {
    private long startTime = 0L;
    private RequestParams<R, Metadata> requestParams;
    private StringBuilder sb;

    @Override
    public void doProcessRequest(RequestParams<R, Metadata> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
        this.sb = new StringBuilder();
    }

    @Override
    public void doProcessResponseHeaders(Metadata responseHeaders) {
    }

    @Override
    public void doProcessResponse(ResponseParams<S> responseParams) {
        String size = null;
        if (responseParams.getResponse() != null) {
            size = String.valueOf(((GeneratedMessageV3)responseParams.getResponse()).getSerializedSize());
        }
        this.sb.append(this.requestParams.getClientIp()).append(" ").append(this.requestParams.getResourcePath()).append(" ").append(size).append(" ").append(System.currentTimeMillis() - this.startTime);
        this.info("access-log", this.sb.toString());
    }

    @Override
    public GrpcFilter<R, S> getInstance() {
        return new AccessLogGrpcFilter<R, S>();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public RequestParams<R, Metadata> getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(RequestParams<R, Metadata> requestParams) {
        this.requestParams = requestParams;
    }

    public StringBuilder getSb() {
        return this.sb;
    }

    public void setSb(StringBuilder sb) {
        this.sb = sb;
    }

    public String toString() {
        return "AccessLogGrpcFilter(startTime=" + this.getStartTime() + ", requestParams=" + this.getRequestParams() + ", sb=" + this.getSb() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessLogGrpcFilter)) {
            return false;
        }
        AccessLogGrpcFilter other = (AccessLogGrpcFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        RequestParams<R, Metadata> this$requestParams = this.getRequestParams();
        RequestParams<R, Metadata> other$requestParams = other.getRequestParams();
        if (this$requestParams == null ? other$requestParams != null : !this$requestParams.equals(other$requestParams)) {
            return false;
        }
        StringBuilder this$sb = this.getSb();
        StringBuilder other$sb = other.getSb();
        return !(this$sb == null ? other$sb != null : !this$sb.equals(other$sb));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessLogGrpcFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        RequestParams<R, Metadata> $requestParams = this.getRequestParams();
        result = result * 59 + ($requestParams == null ? 43 : $requestParams.hashCode());
        StringBuilder $sb = this.getSb();
        result = result * 59 + ($sb == null ? 43 : $sb.hashCode());
        return result;
    }
}

