/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.ResponseParams;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpFilter
extends Filter<ServletRequest, ServletResponse, Set<String>>
implements javax.servlet.Filter {
    private ServletRequest request;
    private ServletResponse response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest requestInput, ServletResponse responseOutput, FilterChain chain) throws IOException, ServletException {
        try {
            this.request = requestInput;
            this.response = responseOutput;
            RequestParams.RequestParamsBuilder requestParamsBuilder = RequestParams.builder();
            requestParamsBuilder.request(this.request);
            if (this.request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)this.request;
                HashSet headersNames = new HashSet(Collections.list(httpServletRequest.getHeaderNames()));
                requestParamsBuilder.metadata(headersNames);
            }
            this.doProcessRequest(requestParamsBuilder.build());
            chain.doFilter(this.request, this.response);
        }
        finally {
            if (this.response instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)this.response;
                this.doProcessResponseHeaders(new HashSet(httpServletResponse.getHeaderNames()));
            }
            this.doProcessResponse(ResponseParams.builder().response(this.response).build());
        }
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public void setRequest(ServletRequest request) {
        this.request = request;
    }

    public void setResponse(ServletResponse response) {
        this.response = response;
    }

    public String toString() {
        return "HttpFilter(request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpFilter)) {
            return false;
        }
        HttpFilter other = (HttpFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServletRequest this$request = this.getRequest();
        ServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        ServletResponse this$response = this.getResponse();
        ServletResponse other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !this$response.equals(other$response));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        ServletResponse $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        return result;
    }
}

