/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.grpc;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.ResponseParams;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;

public class AccessLogGrpcFilter<R extends GeneratedMessageV3, S extends GeneratedMessageV3>
extends GrpcFilter<R, S> {
    private long startTime = 0L;
    private RequestParams<R, Metadata> requestParams;

    @Override
    public GrpcFilter<R, S> getInstance() {
        return new AccessLogGrpcFilter<R, S>();
    }

    @Override
    public void doProcessRequest(RequestParams<R, Metadata> requestParams) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParams;
    }

    @Override
    public void doProcessResponseHeaders(Metadata responseHeaders) {
    }

    @Override
    public void doProcessResponse(ResponseParams<S> responseParams) {
        String size = null;
        if (responseParams.getResponse() != null) {
            size = String.valueOf(((GeneratedMessageV3)responseParams.getResponse()).getSerializedSize());
        }
        StringBuilder sb = new StringBuilder().append(this.requestParams.getClientIp()).append(" ").append(this.requestParams.getResourcePath()).append(" ").append(size).append(" ").append(System.currentTimeMillis() - this.startTime);
        this.info("access-log", sb.toString());
    }
}

