/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.healthcheck;

import com.flipkart.gjex.core.logging.Logging;
import io.dropwizard.metrics5.health.HealthCheck;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;

@Singleton
public class RotationManagementBasedHealthCheck
extends HealthCheck
implements Logging {
    private static final String BIR = "bir";
    private static final String OOR = "oor";
    private static final AtomicBoolean rotationStatus = new AtomicBoolean(true);

    protected HealthCheck.Result check() {
        if (this.inRotation()) {
            return HealthCheck.Result.healthy((String)("Server is " + this.getStatus()));
        }
        return HealthCheck.Result.unhealthy((String)("Server is " + this.getStatus()));
    }

    public String getStatus() {
        return this.inRotation() ? BIR : OOR;
    }

    public String makeOor() {
        rotationStatus.set(false);
        return OOR;
    }

    public String makeBir() {
        rotationStatus.set(true);
        return BIR;
    }

    public boolean inRotation() {
        return rotationStatus.get();
    }
}

