/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.task;

import com.flipkart.gjex.core.task.ConcurrentTask;
import com.flipkart.gjex.core.task.TaskException;
import com.flipkart.gjex.core.task.TaskExecutor;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusException;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function3;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureDecorator<T>
implements Future<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FutureDecorator.class);
    private final ConcurrentTask.Completion completion;
    private final Future<T> origin;
    private final TaskExecutor<T> taskExecutor;
    private BiConsumer<T, Throwable> completionConsumer;

    public FutureDecorator(TaskExecutor<T> taskExecutor, ConcurrentTask.Completion completion) {
        this.taskExecutor = taskExecutor;
        this.origin = taskExecutor.queue();
        this.completion = completion;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.origin.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.origin.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.origin.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        T result = this.origin.get();
        if (result instanceof Future) {
            return (T)((Future)result).get();
        }
        return result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        T result = this.origin.get(timeout, unit);
        if (result instanceof Future) {
            return (T)((Future)result).get();
        }
        return result;
    }

    public ConcurrentTask.Completion getCompletion() {
        return this.completion;
    }

    public TaskExecutor<T> getTaskExecutor() {
        return this.taskExecutor;
    }

    public void whenComplete(BiConsumer<T, Throwable> action) {
        this.completionConsumer = action;
        this.taskExecutor.setCompletionConsumer(this.completionConsumer);
    }

    public static <T1, T2, R> R compose(FutureDecorator<? extends T1> future1, FutureDecorator<? extends T2> future2, BiFunction<? super T1, ? super T2, ? extends R> composer) throws TaskException {
        Object r = null;
        Object t1 = FutureDecorator.getResultFromFuture(future1);
        Object t2 = FutureDecorator.getResultFromFuture(future2);
        try {
            r = composer.apply(t1, t2);
        }
        catch (Exception e) {
            LOGGER.error("Error composing result from Futures : " + e.getMessage(), (Throwable)e);
            throw new TaskException("Error composing result from Futures : " + e.getMessage(), e);
        }
        return (R)r;
    }

    public static <T1, T2, T3, R> R compose(FutureDecorator<? extends T1> future1, FutureDecorator<? extends T2> future2, FutureDecorator<? extends T3> future3, Function3<? super T1, ? super T2, ? super T3, ? extends R> composer) throws TaskException {
        Object r = null;
        Object t1 = FutureDecorator.getResultFromFuture(future1);
        Object t2 = FutureDecorator.getResultFromFuture(future2);
        Object t3 = FutureDecorator.getResultFromFuture(future3);
        try {
            r = composer.apply(t1, t2, t3);
        }
        catch (Exception e) {
            LOGGER.error("Error composing result from Futures : " + e.getMessage(), (Throwable)e);
            throw new TaskException("Error composing result from Futures : " + e.getMessage(), e);
        }
        return (R)r;
    }

    private static Object getResultFromFuture(FutureDecorator future) {
        Object result = null;
        Integer futureGetTimeout = null;
        if (Context.current().getDeadline() != null) {
            if (Context.current().getDeadline().isExpired()) {
                LOGGER.error("Task execution evaluation failed.Deadline exceeded in server execution.");
                throw new TaskException("Task execution evaluation failed.", (Throwable)new StatusException(Status.DEADLINE_EXCEEDED.withDescription("Deadline exceeded in server execution.")));
            }
            futureGetTimeout = (int)Context.current().getDeadline().timeRemaining(TimeUnit.MILLISECONDS);
        }
        if (future.getTaskExecutor().getTimeout() > 0) {
            futureGetTimeout = Math.min(futureGetTimeout, future.getTaskExecutor().getTimeout());
        }
        if (future.getTaskExecutor().isWithRequestHedging() && future.getTaskExecutor().getRollingTailLatency() > 0L) {
            futureGetTimeout = futureGetTimeout == null ? (int)future.getTaskExecutor().getRollingTailLatency() : Math.min(futureGetTimeout, (int)future.getTaskExecutor().getRollingTailLatency());
        }
        try {
            result = futureGetTimeout != null ? (Object)future.get(futureGetTimeout.longValue(), TimeUnit.MILLISECONDS) : (Object)future.get();
        }
        catch (TimeoutException e) {
            if (future.getTaskExecutor().isWithRequestHedging() && !Context.current().getDeadline().isExpired()) {
                LOGGER.info("Sending hedged request for Task : " + future.getTaskExecutor().getInvocation().getMethod().getName());
                result = FutureDecorator.getResultFromFuture(new FutureDecorator(future.getTaskExecutor().clone(), future.getCompletion()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            String errorMessage;
            String string = errorMessage = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
            if (future.getCompletion().equals((Object)ConcurrentTask.Completion.Mandatory)) {
                if (TimeoutException.class.isAssignableFrom(e.getClass())) {
                    throw new TaskException("Task execution results not available.", (Throwable)new StatusException(Status.DEADLINE_EXCEEDED.withDescription("Deadline exceeded waiting for results :" + e.getMessage())));
                }
                throw new TaskException("Error executing mandatory Task : " + errorMessage, e);
            }
            LOGGER.warn("Execution exception in optional task :" + errorMessage + " . Not failing the execution and proceeding.");
        }
        return result;
    }
}

