/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.config;

import java.util.Collection;

public abstract class ConfigurationException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static final String NEWLINE = String.format("%n", new Object[0]);
    private final Collection<String> errors;

    public ConfigurationException(String path, Collection<String> errors) {
        super(ConfigurationException.formatMessage(path, errors));
        this.errors = errors;
    }

    public ConfigurationException(String path, Collection<String> errors, Throwable cause) {
        super(ConfigurationException.formatMessage(path, errors), cause);
        this.errors = errors;
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    protected static String formatMessage(String file, Collection<String> errors) {
        StringBuilder msg = new StringBuilder(file);
        msg.append(errors.size() == 1 ? " has an error:" : " has the following errors:").append(NEWLINE);
        for (String error : errors) {
            msg.append("  * ").append(error).append(NEWLINE);
        }
        return msg.toString();
    }
}

