/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.config.ConfigurationException;
import com.flipkart.gjex.core.config.ConfigurationFactory;
import com.flipkart.gjex.core.config.ConfigurationParsingException;
import com.flipkart.gjex.core.config.ConfigurationSourceProvider;
import com.flipkart.gjex.core.config.ConfigurationValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;
import javax.validation.Validator;

public abstract class BaseConfigurationFactory<T extends GJEXConfiguration, U extends Map>
implements ConfigurationFactory<T, U> {
    protected final Class<T> klass;
    protected final ObjectMapper objectMapper;
    private final Validator validator;
    protected final String formatName;
    private final JsonFactory parserFactory;

    public BaseConfigurationFactory(JsonFactory parserFactory, String formatName, Class<T> klass, Validator validator, ObjectMapper objectMapper) {
        this.klass = klass;
        this.formatName = formatName;
        this.objectMapper = objectMapper;
        this.parserFactory = parserFactory;
        this.validator = validator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<T, U> build(ConfigurationSourceProvider provider, String path) throws IOException, ConfigurationException {
        try (InputStream input = provider.open(Objects.requireNonNull(path));){
            JsonNode node = (JsonNode)this.objectMapper.readTree(this.createParser(input));
            if (node == null) {
                throw ConfigurationParsingException.builder("GJEXConfiguration at " + path + " must not be empty").build(path);
            }
            Pair<T, U> pair = this.build(node, path);
            return pair;
        }
        catch (JsonParseException e) {
            throw ConfigurationParsingException.builder("Malformed " + this.formatName).setCause((Exception)((Object)e)).setLocation(e.getLocation()).setDetail(e.getMessage()).build(path);
        }
    }

    protected JsonParser createParser(InputStream input) throws IOException {
        return this.parserFactory.createParser(input);
    }

    @Override
    public Pair<T, U> build() throws IOException, ConfigurationException {
        try {
            JsonNode node = this.objectMapper.valueToTree(this.klass.newInstance());
            return this.build(node, "Default configuration");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            throw new IllegalArgumentException("Unable create an instance of the configuration class: '" + this.klass.getCanonicalName() + "'", e);
        }
    }

    protected Pair<T, U> build(JsonNode node, String path) throws IOException, ConfigurationException {
        try {
            GJEXConfiguration config = (GJEXConfiguration)this.objectMapper.readValue((JsonParser)new TreeTraversingParser(node), this.klass);
            Map configMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)node), new TypeReference<U>(){});
            this.validate(path, config);
            return new Pair((Object)config, (Object)configMap);
        }
        catch (UnrecognizedPropertyException e) {
            List<String> properties = e.getKnownPropertyIds().stream().map(Object::toString).collect(Collectors.toList());
            throw ConfigurationParsingException.builder("Unrecognized field").setFieldPath(e.getPath()).setLocation(e.getLocation()).addSuggestions(properties).setSuggestionBase(e.getPropertyName()).setCause((Exception)((Object)e)).build(path);
        }
        catch (InvalidFormatException e) {
            String sourceType = e.getValue().getClass().getSimpleName();
            String targetType = e.getTargetType().getSimpleName();
            throw ConfigurationParsingException.builder("Incorrect type of value").setDetail("is of type: " + sourceType + ", expected: " + targetType).setLocation(e.getLocation()).setFieldPath(e.getPath()).setCause((Exception)((Object)e)).build(path);
        }
        catch (JsonMappingException e) {
            throw ConfigurationParsingException.builder("Failed to parse configuration").setDetail(e.getMessage()).setFieldPath(e.getPath()).setLocation(e.getLocation()).setCause((Exception)((Object)e)).build(path);
        }
    }

    private void validate(String path, T config) throws ConfigurationValidationException {
        Set violations;
        if (this.validator != null && !(violations = this.validator.validate(config, new Class[0])).isEmpty()) {
            throw new ConfigurationValidationException(path, violations);
        }
    }
}

