/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spi.models;

import com.flipkart.grayskull.spi.EncryptionService;
import com.flipkart.grayskull.spi.Sensitive;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class EncryptableValue {
    private static final Map<Class<? extends EncryptableValue>, List<Field>> FIELD_CACHE = new ConcurrentHashMap<Class<? extends EncryptableValue>, List<Field>>();
    private String kmsKeyId;
    private boolean encrypted;

    public void encrypt(EncryptionService encryptionService) {
        if (!StringUtils.hasLength((String)this.kmsKeyId)) {
            throw new IllegalStateException("kmsKeyId cannot be empty. please set kmsKeyId before encrypting");
        }
        if (!this.encrypted) {
            for (Field field : this.getSensitiveFields()) {
                String plainText = (String)ReflectionUtils.getField((Field)field, (Object)this);
                String cipherText = encryptionService.encrypt(plainText, this.kmsKeyId);
                ReflectionUtils.setField((Field)field, (Object)this, (Object)cipherText);
            }
            this.encrypted = true;
        }
    }

    public void decrypt(EncryptionService encryptionService) {
        if (!StringUtils.hasLength((String)this.kmsKeyId)) {
            throw new IllegalStateException("kmsKeyId cannot be empty. please set kmsKeyId before decrypting");
        }
        if (this.encrypted) {
            for (Field field : this.getSensitiveFields()) {
                String cipherText = (String)ReflectionUtils.getField((Field)field, (Object)this);
                String plainText = encryptionService.decrypt(cipherText, this.kmsKeyId);
                ReflectionUtils.setField((Field)field, (Object)this, (Object)plainText);
            }
            this.encrypted = false;
        }
    }

    private List<Field> getSensitiveFields() {
        Class<?> cls = this.getClass();
        if (FIELD_CACHE.containsKey(cls)) {
            return FIELD_CACHE.get(cls);
        }
        ArrayList<Field> sensitiveFields = new ArrayList();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.getType().equals(String.class) || !field.isAnnotationPresent(Sensitive.class)) continue;
            field.setAccessible(true);
            sensitiveFields.add(field);
        }
        sensitiveFields = Collections.unmodifiableList(sensitiveFields);
        FIELD_CACHE.put(cls, sensitiveFields);
        return sensitiveFields;
    }

    @Generated
    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    @Generated
    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Generated
    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    @Generated
    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }
}

