/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spi.authz;

import com.flipkart.grayskull.spi.models.Project;
import com.flipkart.grayskull.spi.models.Secret;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.core.Authentication;

public final class AuthorizationContext {
    private final Authentication authentication;
    private final Project project;
    private final Secret secret;

    public static AuthorizationContext forProject(Authentication authentication, Project project) {
        return new AuthorizationContext(authentication, project, null);
    }

    public static AuthorizationContext forSecret(Authentication authentication, Project project, Secret secret) {
        return new AuthorizationContext(authentication, project, secret);
    }

    public Optional<Secret> getSecret() {
        return Optional.ofNullable(this.secret);
    }

    public String getProjectId() {
        return this.project.getId();
    }

    public Optional<String> getSecretName() {
        return this.getSecret().map(Secret::getName);
    }

    @Generated
    private AuthorizationContext(Authentication authentication, Project project, Secret secret) {
        this.authentication = authentication;
        this.project = project;
        this.secret = secret;
    }

    @Generated
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public String toString() {
        return "AuthorizationContext(authentication=" + String.valueOf(this.getAuthentication()) + ", project=" + String.valueOf(this.getProject()) + ", secret=" + String.valueOf(this.getSecret()) + ")";
    }
}

