/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.repositories;

import com.flipkart.grayskull.entities.SecretEntity;
import com.flipkart.grayskull.spi.models.Secret;
import com.flipkart.grayskull.spi.models.enums.LifecycleState;
import com.flipkart.grayskull.spi.repositories.SecretRepository;
import com.flipkart.grayskull.spimpl.repositories.mongo.SecretMongoRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class SecretRepositoryImpl
implements SecretRepository {
    private final SecretMongoRepository mongoRepository;

    public SecretRepositoryImpl(SecretMongoRepository mongoRepository) {
        this.mongoRepository = mongoRepository;
    }

    public List<Secret> findByProjectIdAndState(String projectId, LifecycleState state, int offset, int limit) {
        PageRequest pageable = PageRequest.of((int)0, (int)(offset + limit));
        List<SecretEntity> entities = this.mongoRepository.findByProjectIdAndState(projectId, state, (Pageable)pageable);
        return entities.stream().skip(offset).limit(limit).map(Secret.class::cast).toList();
    }

    public long countByProjectIdAndState(String projectId, LifecycleState state) {
        return this.mongoRepository.countByProjectIdAndState(projectId, state);
    }

    public Optional<Secret> findByProjectIdAndName(String projectId, String name) {
        return this.mongoRepository.findByProjectIdAndName(projectId, name).map(entity -> entity);
    }

    public Optional<Secret> findByProjectIdAndNameAndState(String projectId, String name, LifecycleState state) {
        return this.mongoRepository.findByProjectIdAndNameAndState(projectId, name, state).map(entity -> entity);
    }

    public <S extends Secret> S save(S entity) {
        if (!(entity instanceof SecretEntity)) {
            throw new IllegalArgumentException("Expected SecretEntity but got: " + entity.getClass().getName());
        }
        return (S)((Secret)this.mongoRepository.save((Object)((SecretEntity)entity)));
    }
}

