/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.authn;

import com.flipkart.grayskull.spi.GrayskullAuthenticationProvider;
import com.flipkart.grayskull.spi.authn.GrayskullAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.www.BasicAuthenticationConverter;

public class SimpleAuthenticationProvider
implements GrayskullAuthenticationProvider {
    private static final String PROXY_HEADER = "x-proxy-user";
    private final AuthenticationConverter authenticationConverter = new BasicAuthenticationConverter();
    private AuthenticationManager authenticationManager;

    public void initialize(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public GrayskullAuthentication authenticate(HttpServletRequest request) {
        Authentication authRequest = this.authenticationConverter.convert(request);
        if (authRequest == null) {
            return null;
        }
        Authentication authenticate = this.authenticationManager.authenticate(authRequest);
        String name = authenticate.getName();
        String actor = null;
        if (request.getHeader(PROXY_HEADER) != null) {
            actor = name;
            name = request.getHeader(PROXY_HEADER);
        }
        return new GrayskullAuthentication(name, actor);
    }
}

