/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.service.impl;

import com.flipkart.grayskull.audit.Audit;
import com.flipkart.grayskull.audit.AuditAction;
import com.flipkart.grayskull.configuration.KmsConfig;
import com.flipkart.grayskull.entities.ProjectEntity;
import com.flipkart.grayskull.entities.SecretDataEntity;
import com.flipkart.grayskull.entities.SecretEntity;
import com.flipkart.grayskull.mappers.SecretMapper;
import com.flipkart.grayskull.models.dto.request.CreateSecretRequest;
import com.flipkart.grayskull.models.dto.request.UpgradeSecretDataRequest;
import com.flipkart.grayskull.models.dto.response.ListSecretsResponse;
import com.flipkart.grayskull.models.dto.response.SecretDataResponse;
import com.flipkart.grayskull.models.dto.response.SecretDataVersionResponse;
import com.flipkart.grayskull.models.dto.response.SecretMetadata;
import com.flipkart.grayskull.models.dto.response.SecretResponse;
import com.flipkart.grayskull.models.dto.response.UpgradeSecretDataResponse;
import com.flipkart.grayskull.service.interfaces.SecretService;
import com.flipkart.grayskull.service.utils.AuthnUtil;
import com.flipkart.grayskull.service.utils.SecretEncryptionUtil;
import com.flipkart.grayskull.spi.models.Project;
import com.flipkart.grayskull.spi.models.Secret;
import com.flipkart.grayskull.spi.models.SecretData;
import com.flipkart.grayskull.spi.models.enums.LifecycleState;
import com.flipkart.grayskull.spi.repositories.ProjectRepository;
import com.flipkart.grayskull.spi.repositories.SecretDataRepository;
import com.flipkart.grayskull.spi.repositories.SecretRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SecretServiceImpl
implements SecretService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretServiceImpl.class);
    private final SecretRepository secretRepository;
    private final SecretDataRepository secretDataRepository;
    private final SecretMapper secretMapper;
    private final SecretEncryptionUtil secretEncryptionUtil;
    private final KmsConfig kmsConfig;
    private final ProjectRepository projectRepository;
    private final AuthnUtil authnUtil;

    @Override
    public ListSecretsResponse listSecrets(String projectId, int offset, int limit) {
        List secrets = this.secretRepository.findByProjectIdAndState(projectId, LifecycleState.ACTIVE, offset, limit);
        long total = this.secretRepository.countByProjectIdAndState(projectId, LifecycleState.ACTIVE);
        List<SecretMetadata> secretMetadata = secrets.stream().map(this.secretMapper::secretToSecretMetadata).toList();
        return new ListSecretsResponse(secretMetadata, total);
    }

    @Override
    @Transactional
    @Audit(action=AuditAction.CREATE_SECRET)
    public SecretResponse createSecret(String projectId, CreateSecretRequest request) {
        this.secretRepository.findByProjectIdAndName(projectId, request.getName()).ifPresent(s -> {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "A secret with the same name " + request.getName() + " already exists.");
        });
        String keyId = this.resolveKmsKeyId(projectId);
        SecretEntity secret = this.secretMapper.requestToSecret(request, projectId, this.authnUtil.getCurrentUsername());
        Secret savedSecret = this.secretRepository.save((Secret)secret);
        SecretDataEntity secretData = this.secretMapper.requestToSecretData(request, savedSecret.getId());
        this.secretEncryptionUtil.encryptSecretData(secretData, keyId);
        this.secretDataRepository.save((SecretData)secretData);
        savedSecret.setData((SecretData)secretData);
        return this.secretMapper.secretToSecretResponse(savedSecret);
    }

    @Override
    public SecretMetadata readSecretMetadata(String projectId, String secretName) {
        Secret secret = this.findActiveSecretOrThrow(projectId, secretName);
        return this.secretMapper.secretToSecretMetadata(secret);
    }

    @Override
    public SecretDataResponse readSecretValue(String projectId, String secretName) {
        Secret secret = this.findActiveSecretOrThrow(projectId, secretName);
        SecretData secretData = (SecretData)this.secretDataRepository.getBySecretIdAndDataVersion(secret.getId(), (long)secret.getCurrentDataVersion().intValue()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Secret data not found for secret: " + secret.getId()));
        this.secretEncryptionUtil.decryptSecretData(secretData);
        return this.secretMapper.toSecretDataResponse(secret, secretData);
    }

    @Override
    @Transactional
    @Audit(action=AuditAction.UPGRADE_SECRET_DATA)
    public UpgradeSecretDataResponse upgradeSecretData(String projectId, String secretName, UpgradeSecretDataRequest request) {
        Secret secret = this.findActiveSecretOrThrow(projectId, secretName);
        String keyId = this.resolveKmsKeyId(projectId);
        int newVersion = secret.getCurrentDataVersion() + 1;
        secret.setCurrentDataVersion(Integer.valueOf(newVersion));
        secret.setUpdatedBy(this.authnUtil.getCurrentUsername());
        this.secretRepository.save(secret);
        SecretDataEntity secretData = this.secretMapper.upgradeRequestToSecretData(request, secret, newVersion);
        this.secretEncryptionUtil.encryptSecretData(secretData, keyId);
        this.secretDataRepository.save((SecretData)secretData);
        UpgradeSecretDataResponse response = new UpgradeSecretDataResponse();
        response.setProjectId(projectId);
        response.setName(secretName);
        response.setDataVersion(newVersion);
        response.setLastRotated(secret.getLastRotated());
        response.setCreationTime(secret.getCreationTime());
        response.setUpdatedTime(secret.getUpdatedTime());
        response.setCreatedBy(secret.getCreatedBy());
        response.setUpdatedBy(secret.getUpdatedBy());
        return response;
    }

    @Override
    @Transactional
    @Audit(action=AuditAction.DELETE_SECRET)
    public void deleteSecret(String projectId, String secretName) {
        Secret secret = this.findActiveSecretOrThrow(projectId, secretName);
        secret.setState(LifecycleState.DISABLED);
        secret.setUpdatedBy(this.authnUtil.getCurrentUsername());
        this.secretRepository.save(secret);
    }

    @Override
    public SecretDataVersionResponse getSecretDataVersion(String projectId, String secretName, int version, Optional<LifecycleState> state) {
        Secret secret = state.map(secretState -> (Secret)this.secretRepository.findByProjectIdAndNameAndState(projectId, secretName, secretState).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Secret with name " + secretName + " and state " + String.valueOf(secretState) + " not found."))).orElseGet(() -> this.findActiveSecretOrThrow(projectId, secretName));
        SecretData secretData = (SecretData)this.secretDataRepository.getBySecretIdAndDataVersion(secret.getId(), (long)version).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Secret with name " + secretName + " and version " + version + " not found."));
        this.secretEncryptionUtil.decryptSecretData(secretData);
        return this.secretMapper.secretDataToSecretDataVersionResponse(secret, secretData);
    }

    private Secret findActiveSecretOrThrow(String projectId, String secretName) {
        return (Secret)this.secretRepository.findByProjectIdAndNameAndState(projectId, secretName, LifecycleState.ACTIVE).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Active secret not found with name: " + secretName));
    }

    @Transactional
    public Project getOrCreateProject(String projectId) {
        return this.projectRepository.findById(projectId).orElseGet(() -> {
            String defaultKeyId = this.kmsConfig.getDefaultKeyId();
            Project newProject = ((ProjectEntity.ProjectEntityBuilder)((ProjectEntity.ProjectEntityBuilder)ProjectEntity.builder().id(projectId)).kmsKeyId(defaultKeyId)).build();
            return this.projectRepository.save(newProject);
        });
    }

    private String resolveKmsKeyId(String projectId) {
        Project project = this.getOrCreateProject(projectId);
        String keyId = project.getKmsKeyId();
        if (keyId == null || keyId.isEmpty()) {
            return this.kmsConfig.getDefaultKeyId();
        }
        return keyId;
    }

    @Generated
    public SecretServiceImpl(SecretRepository secretRepository, SecretDataRepository secretDataRepository, SecretMapper secretMapper, SecretEncryptionUtil secretEncryptionUtil, KmsConfig kmsConfig, ProjectRepository projectRepository, AuthnUtil authnUtil) {
        this.secretRepository = secretRepository;
        this.secretDataRepository = secretDataRepository;
        this.secretMapper = secretMapper;
        this.secretEncryptionUtil = secretEncryptionUtil;
        this.kmsConfig = kmsConfig;
        this.projectRepository = projectRepository;
        this.authnUtil = authnUtil;
    }
}

