/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.service.impl;

import com.flipkart.grayskull.configuration.KmsConfig;
import com.flipkart.grayskull.exception.AlreadyExistsException;
import com.flipkart.grayskull.exception.NotFoundException;
import com.flipkart.grayskull.mappers.SecretProviderMapper;
import com.flipkart.grayskull.models.dto.request.CreateSecretProviderRequest;
import com.flipkart.grayskull.models.dto.request.SecretProviderRequest;
import com.flipkart.grayskull.service.interfaces.SecretProviderService;
import com.flipkart.grayskull.service.utils.SecretEncryptionUtil;
import com.flipkart.grayskull.spi.models.SecretProvider;
import com.flipkart.grayskull.spi.repositories.SecretProviderRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SecretProviderServiceImpl
implements SecretProviderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretProviderServiceImpl.class);
    private final SecretProviderRepository secretProviderRepository;
    private final SecretProviderMapper secretProviderMapper;
    private final SecretEncryptionUtil secretEncryptionUtil;
    private final KmsConfig kmsConfig;

    @Override
    public List<SecretProvider> listProviders() {
        return this.secretProviderRepository.findAll();
    }

    @Override
    public SecretProvider getProvider(String name) {
        return (SecretProvider)this.secretProviderRepository.findByName(name).orElseThrow(() -> new NotFoundException("Secret provider not found with name: " + name));
    }

    @Override
    @Transactional
    public SecretProvider createProvider(CreateSecretProviderRequest request) {
        log.debug("Creating secret provider with name: {}", (Object)request.getName());
        SecretProvider provider = this.secretProviderMapper.requestToSecretProvider(request);
        this.secretEncryptionUtil.encrypt(provider.getAuthAttributes(), this.kmsConfig.getDefaultKeyId());
        try {
            SecretProvider savedProvider = this.secretProviderRepository.save(provider);
            log.info("Successfully created secret provider with name: {}", (Object)request.getName());
            return savedProvider;
        }
        catch (DuplicateKeyException e) {
            throw new AlreadyExistsException("A secret provider with the same name " + request.getName() + " already exists.");
        }
    }

    @Override
    @Transactional
    public SecretProvider updateProvider(String name, SecretProviderRequest request) {
        log.debug("Updating secret provider with name: {}", (Object)name);
        SecretProvider existingProvider = (SecretProvider)this.secretProviderRepository.findByName(name).orElseThrow(() -> new NotFoundException("Secret provider not found with name: " + name));
        this.secretProviderMapper.updateSecretProviderFromRequest(request, existingProvider);
        this.secretEncryptionUtil.encrypt(existingProvider.getAuthAttributes(), this.kmsConfig.getDefaultKeyId());
        SecretProvider updatedProvider = this.secretProviderRepository.save(existingProvider);
        log.info("Successfully updated secret provider with name: {}", (Object)name);
        return updatedProvider;
    }

    @Generated
    public SecretProviderServiceImpl(SecretProviderRepository secretProviderRepository, SecretProviderMapper secretProviderMapper, SecretEncryptionUtil secretEncryptionUtil, KmsConfig kmsConfig) {
        this.secretProviderRepository = secretProviderRepository;
        this.secretProviderMapper = secretProviderMapper;
        this.secretEncryptionUtil = secretEncryptionUtil;
        this.kmsConfig = kmsConfig;
    }
}

