/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.exception;

import com.flipkart.grayskull.models.dto.response.ResponseTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GrayskullErrorController
extends AbstractErrorController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrayskullErrorController.class);

    public GrayskullErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<ResponseTemplate<Void>> handleError(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        Map errorAttributes = this.getErrorAttributes(request, ErrorAttributeOptions.defaults().including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE}).including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION}));
        if (errorAttributes.containsKey("exception")) {
            this.logException(errorAttributes);
        }
        return new ResponseEntity(ResponseTemplate.error(errorAttributes.get("message").toString(), errorAttributes.get("error").toString()), (HttpStatusCode)status);
    }

    void logException(Map<String, Object> errorAttributes) {
        log.error("Exception occurred with message {}", (Object)errorAttributes.get("message").toString(), errorAttributes.get("exception"));
    }
}

