/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.exception;

import com.flipkart.grayskull.models.dto.response.ResponseTemplate;
import com.flipkart.grayskull.models.dto.response.Violation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ConstraintViolationException.class, MethodArgumentTypeMismatchException.class})
    public ResponseEntity<ResponseTemplate<Void>> handleValidationException(Exception ex, WebRequest request) {
        List<Violation> violations = new ArrayList<Violation>();
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException constraintEx = (ConstraintViolationException)ex;
            violations = constraintEx.getConstraintViolations().stream().map(cv -> new Violation(cv.getPropertyPath().toString(), cv.getMessage())).toList();
        } else if (ex instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException typeMismatchEx = (MethodArgumentTypeMismatchException)ex;
            String message = String.format("Could not convert value '%s' to type '%s'", typeMismatchEx.getValue(), Objects.requireNonNull(typeMismatchEx.getRequiredType()).getSimpleName());
            violations = List.of(new Violation(typeMismatchEx.getName(), message));
        }
        ResponseTemplate<Void> errorResponse = ResponseTemplate.validationError("Validation failed", HttpStatus.BAD_REQUEST.name(), violations);
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<ResponseTemplate<Void>> handleResponseStatusException(ResponseStatusException ex, WebRequest request) {
        String errorCode = "";
        HttpStatusCode httpStatusCode = ex.getStatusCode();
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            errorCode = status.name();
        } else {
            errorCode = String.valueOf(ex.getStatusCode().value());
        }
        ResponseTemplate<Void> errorResponse = ResponseTemplate.error(ex.getReason(), errorCode);
        return new ResponseEntity(errorResponse, ex.getStatusCode());
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ResponseTemplate<Void>> handleAccessDeniedException(AccessDeniedException ex, WebRequest request) {
        ResponseTemplate<Void> errorResponse = ResponseTemplate.error(ex.getMessage(), HttpStatus.FORBIDDEN.name());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class})
    public ResponseEntity<ResponseTemplate<Void>> handleOptimisticLockingFailure(OptimisticLockingFailureException ex, WebRequest request) {
        log.warn("Optimistic locking failure detected - concurrent modification: {}", (Object)ex.getMessage());
        ResponseTemplate<Void> errorResponse = ResponseTemplate.error("The resource was modified by another request. Please refresh and try again.", HttpStatus.CONFLICT.name());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ResponseTemplate<Void>> handleAllExceptions(Exception ex, WebRequest request) {
        log.error("An unexpected error occurred", (Throwable)ex);
        ResponseTemplate<Void> errorResponse = ResponseTemplate.error("An unexpected internal server error occurred.", HttpStatus.INTERNAL_SERVER_ERROR.name());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        String message = "Request method '" + ex.getMethod() + "' not supported. Supported methods are " + String.valueOf(ex.getSupportedHttpMethods());
        ResponseTemplate<Void> errorResponse = ResponseTemplate.error(message, HttpStatus.METHOD_NOT_ALLOWED.name());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        ResponseTemplate<Void> errorResponse = ResponseTemplate.error("Malformed JSON request", HttpStatus.UNPROCESSABLE_ENTITY.name());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        List<Violation> violations = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> new Violation(fieldError.getField(), fieldError.getDefaultMessage())).toList();
        ResponseTemplate<Void> errorResponse = ResponseTemplate.validationError("Validation failed", HttpStatus.BAD_REQUEST.name(), violations);
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

