/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.controllers;

import com.flipkart.grayskull.models.dto.request.CreateSecretProviderRequest;
import com.flipkart.grayskull.models.dto.request.SecretProviderRequest;
import com.flipkart.grayskull.service.interfaces.SecretProviderService;
import com.flipkart.grayskull.spi.models.SecretProvider;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/providers"})
@Validated
public class SecretProviderController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretProviderController.class);
    private final SecretProviderService secretProviderService;

    @GetMapping
    @PreAuthorize(value="@grayskullSecurity.hasPermission('providers.list')")
    public ResponseEntity<List<SecretProvider>> listProviders() {
        log.debug("Received request to list all secret providers");
        List<SecretProvider> response = this.secretProviderService.listProviders();
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{name}"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission('providers.read')")
    public ResponseEntity<SecretProvider> getProvider(@PathVariable @NotBlank String name) {
        log.debug("Received request to get secret provider: {}", (Object)name);
        SecretProvider response = this.secretProviderService.getProvider(name);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    @PreAuthorize(value="@grayskullSecurity.hasPermission('providers.create')")
    public ResponseEntity<SecretProvider> createProvider(@Valid @RequestBody CreateSecretProviderRequest request) {
        log.debug("Received request to create secret provider: {}", (Object)request.getName());
        this.validateAuthAttributes(request);
        SecretProvider response = this.secretProviderService.createProvider(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    private void validateAuthAttributes(SecretProviderRequest request) {
        if (!request.getAuthMechanism().getAttributesClass().isInstance(request.getAuthAttributes())) {
            throw new IllegalArgumentException("Invalid auth attributes for auth mechanism: " + String.valueOf(request.getAuthMechanism()));
        }
    }

    @PutMapping(value={"/{name}"})
    @PreAuthorize(value="@grayskullSecurity.hasPermission('providers.update')")
    public ResponseEntity<SecretProvider> updateProvider(@PathVariable @NotBlank String name, @Valid @RequestBody SecretProviderRequest request) {
        log.debug("Received request to update secret provider: {}", (Object)name);
        this.validateAuthAttributes(request);
        SecretProvider response = this.secretProviderService.updateProvider(name, request);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public SecretProviderController(SecretProviderService secretProviderService) {
        this.secretProviderService = secretProviderService;
    }
}

