/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.authz;

import com.flipkart.grayskull.spi.GrayskullAuthorizationProvider;
import com.flipkart.grayskull.spi.authn.GrayskullAuthentication;
import com.flipkart.grayskull.spi.authz.AuthorizationContext;
import com.flipkart.grayskull.spi.models.Project;
import com.flipkart.grayskull.spi.models.Secret;
import com.flipkart.grayskull.spi.repositories.ProjectRepository;
import com.flipkart.grayskull.spi.repositories.SecretProviderRepository;
import com.flipkart.grayskull.spi.repositories.SecretRepository;
import lombok.Generated;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class GrayskullSecurity {
    private final ProjectRepository projectRepository;
    private final SecretRepository secretRepository;
    private final SecretProviderRepository secretProviderRepository;
    private final GrayskullAuthorizationProvider authorizationProvider;

    public boolean hasPermission(String projectId, String action) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Project project = this.projectRepository.findByIdOrTransient(projectId);
        AuthorizationContext context = AuthorizationContext.forProject((Authentication)authentication, (Project)project);
        return this.authorizationProvider.isAuthorized(context, action);
    }

    public boolean hasPermission(String projectId, String secretName, String action) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.projectRepository.findById(projectId).map(project -> this.secretRepository.findByProjectIdAndName(project.getId(), secretName).map(secret -> {
            AuthorizationContext context = AuthorizationContext.forSecret((Authentication)authentication, (Project)project, (Secret)secret);
            return this.authorizationProvider.isAuthorized(context, action);
        }).orElseGet(() -> {
            AuthorizationContext context = AuthorizationContext.forProject((Authentication)authentication, (Project)project);
            return this.authorizationProvider.isAuthorized(context, action);
        })).orElse(false);
    }

    public boolean hasPermission(String action) {
        GrayskullAuthentication authentication = (GrayskullAuthentication)SecurityContextHolder.getContext().getAuthentication();
        return this.authorizationProvider.isAuthorized(authentication, action);
    }

    public boolean checkProviderAuthorization(String providerName) {
        if ("SELF".equals(providerName)) {
            return true;
        }
        GrayskullAuthentication authentication = (GrayskullAuthentication)SecurityContextHolder.getContext().getAuthentication();
        String actorName = authentication.getActor();
        if (actorName == null) {
            throw new AccessDeniedException("Expected an actor name for the " + providerName + " managed secrets");
        }
        return this.secretProviderRepository.findByName(providerName).filter(secretProvider -> secretProvider.getPrincipal().equals(actorName)).isPresent();
    }

    @Generated
    public GrayskullSecurity(ProjectRepository projectRepository, SecretRepository secretRepository, SecretProviderRepository secretProviderRepository, GrayskullAuthorizationProvider authorizationProvider) {
        this.projectRepository = projectRepository;
        this.secretRepository = secretRepository;
        this.secretProviderRepository = secretProviderRepository;
        this.authorizationProvider = authorizationProvider;
    }
}

