/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.authn;

import com.flipkart.grayskull.authn.AuthenticationFilterSecurityConfigurer;
import com.flipkart.grayskull.spi.GrayskullAuthenticationProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableMethodSecurity
public class SecurityConfiguration {
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, GrayskullAuthenticationProvider authenticationProvider) throws Exception {
        http.sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new String[]{"/swagger-ui.html", "/swagger-ui/**", "/swagger-resources/**", "/v3/api-docs/**", "/error", "/actuator/**"})).permitAll().anyRequest()).authenticated()).exceptionHandling(ex -> ex.authenticationEntryPoint((request, response, e) -> response.sendError(401, e.getMessage()))).csrf(AbstractHttpConfigurer::disable);
        http.apply((SecurityConfigurer)new AuthenticationFilterSecurityConfigurer(authenticationProvider));
        return (SecurityFilterChain)http.build();
    }
}

