/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.validation;

import com.flipkart.grayskull.exception.BadRequestException;
import com.flipkart.grayskull.spi.MetadataValidator;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.validator.routines.UrlValidator;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public final class ExternalProviderMetadataValidator
implements MetadataValidator {
    private static final Set<String> SENSITIVE_KEYS = Set.of("password", "pwd", "passwd", "pass", "credential", "secret", "client_secret", "token", "access_token", "auth_token", "apikey", "api_key", "jwt", "bearer", "sid", "sessionid", "jsessionid", "phpsessid", "aspsessionid", "cookie");
    private final UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"});

    public void validateMetadata(String provider, Map<String, Object> metadata) {
        if ("SELF".equals(provider)) {
            return;
        }
        this.validateParam(metadata, "revokeUrl");
        this.validateParam(metadata, "rotateUrl");
    }

    private void validateParam(Map<String, Object> metadata, String key) {
        Object object = metadata.get(key);
        if (!(object instanceof String)) {
            throw new BadRequestException("expected mandatory key '" + key + "' in the providerMeta");
        }
        String url = (String)object;
        if (!this.urlValidator.isValid(url)) {
            throw new BadRequestException("invalid url: " + url + " for the providerMeta key: " + key);
        }
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)url).build().getQueryParams();
        queryParams.keySet().forEach(k -> {
            if (SENSITIVE_KEYS.contains(k.toLowerCase())) {
                throw new BadRequestException("sensitive key: " + k + " in the providerMeta key: " + key);
            }
        });
    }

    @Generated
    public ExternalProviderMetadataValidator() {
    }
}

