/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.service.utils;

import com.flipkart.grayskull.spi.EncryptionService;
import com.flipkart.grayskull.spi.models.EncryptableValue;
import com.flipkart.grayskull.spi.models.SecretData;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class SecretEncryptionUtil {
    private final EncryptionService encryptionService;

    public void encryptSecretData(SecretData secretData, String keyId) {
        if (secretData.getPrivatePart() != null && !secretData.getPrivatePart().isEmpty()) {
            secretData.setPrivatePart(this.encryptionService.encrypt(secretData.getPrivatePart(), keyId));
            secretData.setKmsKeyId(keyId);
        }
    }

    public void decryptSecretData(SecretData secretData) {
        if (secretData.getPrivatePart() != null && !secretData.getPrivatePart().isEmpty()) {
            String decrypted = this.encryptionService.decrypt(secretData.getPrivatePart(), secretData.getKmsKeyId());
            secretData.setPrivatePart(decrypted);
        }
    }

    public void encrypt(Object o, String key) {
        if (o instanceof EncryptableValue) {
            EncryptableValue value = (EncryptableValue)o;
            value.setKmsKeyId(key);
            value.encrypt(this.encryptionService);
        }
    }

    @Generated
    public SecretEncryptionUtil(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

