/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.mappers;

import com.flipkart.grayskull.entities.SecretDataEntity;
import com.flipkart.grayskull.mappers.GeneratedMapper;
import com.flipkart.grayskull.mappers.SecretMapper;
import com.flipkart.grayskull.models.dto.request.CreateSecretRequest;
import com.flipkart.grayskull.models.dto.request.SecretDataPayload;
import com.flipkart.grayskull.models.dto.request.UpgradeSecretDataRequest;
import com.flipkart.grayskull.models.dto.response.SecretDataResponse;
import com.flipkart.grayskull.models.dto.response.SecretDataVersionResponse;
import com.flipkart.grayskull.models.dto.response.SecretMetadata;
import com.flipkart.grayskull.models.dto.response.SecretResponse;
import com.flipkart.grayskull.spi.models.Secret;
import com.flipkart.grayskull.spi.models.SecretData;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
@GeneratedMapper
public class SecretMapperImpl
implements SecretMapper {
    @Override
    public SecretDataEntity requestToSecretData(CreateSecretRequest request, String secretId) {
        if (request == null && secretId == null) {
            return null;
        }
        SecretDataEntity.SecretDataEntityBuilder<?, ?> secretDataEntity = SecretDataEntity.builder();
        if (request != null) {
            secretDataEntity.privatePart(this.requestDataPrivatePart(request));
            secretDataEntity.publicPart(this.requestDataPublicPart(request));
        }
        secretDataEntity.secretId(secretId);
        secretDataEntity.id(UUID.randomUUID().toString());
        secretDataEntity.dataVersion(1L);
        return secretDataEntity.build();
    }

    @Override
    public SecretDataEntity upgradeRequestToSecretData(UpgradeSecretDataRequest request, Secret secret, int newVersion) {
        if (request == null && secret == null) {
            return null;
        }
        SecretDataEntity.SecretDataEntityBuilder<?, ?> secretDataEntity = SecretDataEntity.builder();
        if (request != null) {
            secretDataEntity.publicPart(request.getPublicPart());
            secretDataEntity.privatePart(request.getPrivatePart());
        }
        if (secret != null) {
            secretDataEntity.secretId(secret.getId());
            secretDataEntity.state(secret.getState());
        }
        secretDataEntity.dataVersion(newVersion);
        secretDataEntity.id(UUID.randomUUID().toString());
        return secretDataEntity.build();
    }

    @Override
    public SecretMetadata secretToSecretMetadata(Secret secret) {
        if (secret == null) {
            return null;
        }
        String projectId = null;
        String name = null;
        LinkedHashMap<String, String> systemLabels = null;
        int currentDataVersion = 0;
        Instant lastRotated = null;
        Instant creationTime = null;
        Instant updatedTime = null;
        String createdBy = null;
        String updatedBy = null;
        String state = null;
        String provider = null;
        LinkedHashMap<String, Object> providerMeta = null;
        int metadataVersion = 0;
        projectId = secret.getProjectId();
        name = secret.getName();
        Map map = secret.getSystemLabels();
        if (map != null) {
            systemLabels = new LinkedHashMap<String, String>(map);
        }
        if (secret.getCurrentDataVersion() != null) {
            currentDataVersion = secret.getCurrentDataVersion();
        }
        lastRotated = secret.getLastRotated();
        creationTime = secret.getCreationTime();
        updatedTime = secret.getUpdatedTime();
        createdBy = secret.getCreatedBy();
        updatedBy = secret.getUpdatedBy();
        state = this.lifecycleStateToString(secret.getState());
        provider = secret.getProvider();
        Map map1 = secret.getProviderMeta();
        if (map1 != null) {
            providerMeta = new LinkedHashMap<String, Object>(map1);
        }
        if (secret.getMetadataVersion() != null) {
            metadataVersion = secret.getMetadataVersion();
        }
        SecretMetadata secretMetadata = new SecretMetadata(projectId, name, systemLabels, currentDataVersion, lastRotated, creationTime, updatedTime, createdBy, updatedBy, state, provider, providerMeta, metadataVersion);
        return secretMetadata;
    }

    @Override
    public SecretResponse secretToSecretResponse(Secret secret) {
        if (secret == null) {
            return null;
        }
        String projectId = null;
        String name = null;
        LinkedHashMap<String, String> systemLabels = null;
        int currentDataVersion = 0;
        Instant lastRotated = null;
        String state = null;
        String provider = null;
        LinkedHashMap<String, Object> providerMeta = null;
        int metadataVersion = 0;
        projectId = secret.getProjectId();
        name = secret.getName();
        Map map = secret.getSystemLabels();
        if (map != null) {
            systemLabels = new LinkedHashMap<String, String>(map);
        }
        if (secret.getCurrentDataVersion() != null) {
            currentDataVersion = secret.getCurrentDataVersion();
        }
        lastRotated = secret.getLastRotated();
        state = this.lifecycleStateToString(secret.getState());
        provider = secret.getProvider();
        Map map1 = secret.getProviderMeta();
        if (map1 != null) {
            providerMeta = new LinkedHashMap<String, Object>(map1);
        }
        if (secret.getMetadataVersion() != null) {
            metadataVersion = secret.getMetadataVersion();
        }
        SecretResponse secretResponse = new SecretResponse(projectId, name, systemLabels, currentDataVersion, lastRotated, state, provider, providerMeta, metadataVersion);
        return secretResponse;
    }

    @Override
    public SecretDataResponse toSecretDataResponse(Secret secret, SecretData secretData) {
        if (secret == null && secretData == null) {
            return null;
        }
        SecretDataResponse.SecretDataResponseBuilder secretDataResponse = SecretDataResponse.builder();
        if (secret != null) {
            secretDataResponse.state(this.lifecycleStateToString(secret.getState()));
            secretDataResponse.lastRotated(secret.getLastRotated());
            secretDataResponse.creationTime(secret.getCreationTime());
            secretDataResponse.updatedTime(secret.getUpdatedTime());
            secretDataResponse.createdBy(secret.getCreatedBy());
            secretDataResponse.updatedBy(secret.getUpdatedBy());
        }
        if (secretData != null) {
            secretDataResponse.dataVersion((int)secretData.getDataVersion());
            secretDataResponse.publicPart(secretData.getPublicPart());
            secretDataResponse.privatePart(secretData.getPrivatePart());
        }
        return secretDataResponse.build();
    }

    @Override
    public SecretDataVersionResponse secretDataToSecretDataVersionResponse(Secret secret, SecretData secretData) {
        if (secret == null && secretData == null) {
            return null;
        }
        SecretDataVersionResponse.SecretDataVersionResponseBuilder secretDataVersionResponse = SecretDataVersionResponse.builder();
        if (secret != null) {
            secretDataVersionResponse.state(this.lifecycleStateToString(secret.getState()));
            secretDataVersionResponse.lastRotated(secret.getLastRotated());
            secretDataVersionResponse.creationTime(secret.getCreationTime());
            secretDataVersionResponse.updatedTime(secret.getUpdatedTime());
            secretDataVersionResponse.createdBy(secret.getCreatedBy());
            secretDataVersionResponse.updatedBy(secret.getUpdatedBy());
        }
        if (secretData != null) {
            secretDataVersionResponse.dataVersion((int)secretData.getDataVersion());
            secretDataVersionResponse.publicPart(secretData.getPublicPart());
            secretDataVersionResponse.privatePart(secretData.getPrivatePart());
        }
        return secretDataVersionResponse.build();
    }

    private String requestDataPrivatePart(CreateSecretRequest createSecretRequest) {
        SecretDataPayload data = createSecretRequest.getData();
        if (data == null) {
            return null;
        }
        return data.getPrivatePart();
    }

    private String requestDataPublicPart(CreateSecretRequest createSecretRequest) {
        SecretDataPayload data = createSecretRequest.getData();
        if (data == null) {
            return null;
        }
        return data.getPublicPart();
    }
}

