/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.aspects;

import com.flipkart.grayskull.configuration.properties.ReadOnlyAppProperties;
import io.micrometer.common.lang.Nullable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;

@Aspect
@Component
public class ReadOnlyAspect {
    private final ReadOnlyAppProperties readOnlyAppProperties;

    public ReadOnlyAspect(ReadOnlyAppProperties readOnlyAppProperties) {
        this.readOnlyAppProperties = readOnlyAppProperties;
    }

    @Around(value="@within(org.springframework.web.bind.annotation.RestController) && !@annotation(org.springframework.web.bind.annotation.GetMapping) && !@annotation(com.flipkart.grayskull.aspects.annotations.BypassReadOnly) && execution(* *(..))")
    @Nullable
    public Object enforceReadOnlyMode(ProceedingJoinPoint pjp) throws Throwable {
        if (!this.readOnlyAppProperties.isEnabled()) {
            return pjp.proceed();
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED, "The application server is read only. The specified operation is not allowed.");
    }
}

