/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.crypto;

import com.flipkart.grayskull.spi.EncryptionService;
import com.flipkart.grayskull.spimpl.crypto.KeyProperties;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaChaEncryptionService
implements EncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChaChaEncryptionService.class);
    private static final String CHACHA_CIPHER_ALGORITHM = "ChaCha20-Poly1305/None/NoPadding";
    private static final String CHACHA_SECRETKEY_ALGORITHM = "ChaCha20";
    private static final int NONCE_SIZE_BYTES = 12;
    private final Map<String, byte[]> keys;

    public ChaChaEncryptionService(KeyProperties properties) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (Map.Entry<String, String> entry : properties.getKeys().entrySet()) {
            map.put(entry.getKey(), Base64.getDecoder().decode(entry.getValue()));
        }
        this.keys = Map.copyOf(map);
        this.validateKeys();
    }

    public void validateKeys() {
        byte[] s = RandomUtils.secure().randomBytes(16);
        for (String key : this.keys.keySet()) {
            log.debug("Validating key: {}", (Object)key);
            byte[] encrypted = this.encrypt(s, key);
            byte[] decrypted = this.decrypt(encrypted, key);
            if (Arrays.equals(s, decrypted)) continue;
            throw new IllegalStateException("Decryption failed for key: " + key);
        }
    }

    public byte[] encrypt(byte[] data, String keyId) {
        try {
            Cipher cipher = Cipher.getInstance(CHACHA_CIPHER_ALGORITHM);
            cipher.init(1, new SecretKeySpec(this.keys.get(keyId), CHACHA_SECRETKEY_ALGORITHM));
            byte[] nonce = cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
            byte[] encryptedBytes = cipher.doFinal(data);
            byte[] combined = new byte[nonce.length + encryptedBytes.length];
            System.arraycopy(nonce, 0, combined, 0, nonce.length);
            System.arraycopy(encryptedBytes, 0, combined, nonce.length, encryptedBytes.length);
            return combined;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] decrypt(byte[] data, String keyId) {
        try {
            byte[] nonce = new byte[12];
            byte[] cipherBytes = new byte[data.length - 12];
            System.arraycopy(data, 0, nonce, 0, 12);
            System.arraycopy(data, 12, cipherBytes, 0, cipherBytes.length);
            Cipher cipher = Cipher.getInstance(CHACHA_CIPHER_ALGORITHM);
            cipher.init(2, (Key)new SecretKeySpec(this.keys.get(keyId), CHACHA_SECRETKEY_ALGORITHM), new IvParameterSpec(nonce));
            return cipher.doFinal(cipherBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

