/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.grayskull.spimpl.authn;

import com.flipkart.grayskull.spi.GrayskullAuthenticationProvider;
import com.flipkart.grayskull.spimpl.authn.SimpleAuthenticationProvider;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@ConditionalOnMissingBean(value={GrayskullAuthenticationProvider.class})
public class AuthenticationConfiguration {
    @Bean
    public GrayskullAuthenticationProvider authenticationProvider() {
        return new SimpleAuthenticationProvider();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new DummyPasswordEncoder();
    }

    @Bean
    public OpenApiCustomizer securityOpenApiCustomizer() {
        return openApi -> {
            openApi.addSecurityItem(new SecurityRequirement().addList("BasicAuth"));
            openApi.schemaRequirement("BasicAuth", new SecurityScheme().type(SecurityScheme.Type.HTTP).in(SecurityScheme.In.HEADER).name("Authorization").scheme("basic"));
        };
    }

    @Bean
    public UserDetailsService userDetailsService() {
        return username -> User.withUsername((String)username).roles(new String[]{"USER"}).password("").build();
    }

    public static class DummyPasswordEncoder
    implements PasswordEncoder {
        public String encode(CharSequence rawPassword) {
            return rawPassword.toString();
        }

        public boolean matches(CharSequence rawPassword, String encodedPassword) {
            return true;
        }
    }
}

